/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is the output iterable model for &#39;/machine_learning/text/technical_language/parsers/segmentation&#39;  specific is optional here, however you can pass in classify: true to get the specific classificaiton in the case the generic is code.
    /// </summary>
    [DataContract(Name = "SegmentedTechnicalLanguageFragment")]
    public partial class SegmentedTechnicalLanguageFragment : IValidatableObject
    {

        /// <summary>
        /// Gets or Sets Generic
        /// </summary>
        [DataMember(Name = "generic", IsRequired = true, EmitDefaultValue = true)]
        public ClassificationGenericEnum Generic { get; set; }

        /// <summary>
        /// Gets or Sets Specific
        /// </summary>
        [DataMember(Name = "specific", EmitDefaultValue = false)]
        public ClassificationSpecificEnum? Specific { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="SegmentedTechnicalLanguageFragment" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected SegmentedTechnicalLanguageFragment() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="SegmentedTechnicalLanguageFragment" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="generic">generic (required).</param>
        /// <param name="specific">specific.</param>
        /// <param name="fragment">fragment (required).</param>
        public SegmentedTechnicalLanguageFragment(EmbeddedModelSchema schema = default(EmbeddedModelSchema), ClassificationGenericEnum generic = default(ClassificationGenericEnum), ClassificationSpecificEnum? specific = default(ClassificationSpecificEnum?), FragmentFormat fragment = default(FragmentFormat))
        {
            this.Generic = generic;
            // to ensure "fragment" is required (not null)
            if (fragment == null)
            {
                throw new ArgumentNullException("fragment is a required property for SegmentedTechnicalLanguageFragment and cannot be null");
            }
            this.Fragment = fragment;
            this.Schema = schema;
            this.Specific = specific;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Fragment
        /// </summary>
        [DataMember(Name = "fragment", IsRequired = true, EmitDefaultValue = true)]
        public FragmentFormat Fragment { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class SegmentedTechnicalLanguageFragment {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Generic: ").Append(Generic).Append("\n");
            sb.Append("  Specific: ").Append(Specific).Append("\n");
            sb.Append("  Fragment: ").Append(Fragment).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
