/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is a model that will hold relavent information in relation to a keyboard(including shortcuts) analytics event (usage).
    /// </summary>
    [DataContract(Name = "SeededTrackedKeyboardEvent")]
    public partial class SeededTrackedKeyboardEvent : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="SeededTrackedKeyboardEvent" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected SeededTrackedKeyboardEvent() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="SeededTrackedKeyboardEvent" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="description">This also needs structure such as key vals or enums (required).</param>
        /// <param name="shortcut">shortcut (required).</param>
        /// <param name="identifierDescriptionPair">identifierDescriptionPair.</param>
        public SeededTrackedKeyboardEvent(EmbeddedModelSchema schema = default(EmbeddedModelSchema), string description = default(string), List<int> shortcut = default(List<int>), SeededTrackedKeyboardEventIdentifierDescriptionPairs identifierDescriptionPair = default(SeededTrackedKeyboardEventIdentifierDescriptionPairs))
        {
            // to ensure "description" is required (not null)
            if (description == null)
            {
                throw new ArgumentNullException("description is a required property for SeededTrackedKeyboardEvent and cannot be null");
            }
            this.Description = description;
            // to ensure "shortcut" is required (not null)
            if (shortcut == null)
            {
                throw new ArgumentNullException("shortcut is a required property for SeededTrackedKeyboardEvent and cannot be null");
            }
            this.Shortcut = shortcut;
            this.Schema = schema;
            this.IdentifierDescriptionPair = identifierDescriptionPair;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// This also needs structure such as key vals or enums
        /// </summary>
        /// <value>This also needs structure such as key vals or enums</value>
        [DataMember(Name = "description", IsRequired = true, EmitDefaultValue = true)]
        public string Description { get; set; }

        /// <summary>
        /// Gets or Sets Shortcut
        /// </summary>
        [DataMember(Name = "shortcut", IsRequired = true, EmitDefaultValue = true)]
        public List<int> Shortcut { get; set; }

        /// <summary>
        /// Gets or Sets IdentifierDescriptionPair
        /// </summary>
        [DataMember(Name = "identifier_description_pair", EmitDefaultValue = false)]
        public SeededTrackedKeyboardEventIdentifierDescriptionPairs IdentifierDescriptionPair { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class SeededTrackedKeyboardEvent {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Description: ").Append(Description).Append("\n");
            sb.Append("  Shortcut: ").Append(Shortcut).Append("\n");
            sb.Append("  IdentifierDescriptionPair: ").Append(IdentifierDescriptionPair).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
