/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is a pre-created(seed) TrackedConversationEvent
    /// </summary>
    [DataContract(Name = "SeededTrackedConversationEvent")]
    public partial class SeededTrackedConversationEvent : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="SeededTrackedConversationEvent" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected SeededTrackedConversationEvent() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="SeededTrackedConversationEvent" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="identifierDescriptionPair">identifierDescriptionPair (required).</param>
        /// <param name="conversation">conversation (required).</param>
        /// <param name="metadata">metadata.</param>
        public SeededTrackedConversationEvent(EmbeddedModelSchema schema = default(EmbeddedModelSchema), TrackedConversationEventIdentifierDescriptionPairs identifierDescriptionPair = default(TrackedConversationEventIdentifierDescriptionPairs), ReferencedConversation conversation = default(ReferencedConversation), TrackedConversationEventMetadata metadata = default(TrackedConversationEventMetadata))
        {
            // to ensure "identifierDescriptionPair" is required (not null)
            if (identifierDescriptionPair == null)
            {
                throw new ArgumentNullException("identifierDescriptionPair is a required property for SeededTrackedConversationEvent and cannot be null");
            }
            this.IdentifierDescriptionPair = identifierDescriptionPair;
            // to ensure "conversation" is required (not null)
            if (conversation == null)
            {
                throw new ArgumentNullException("conversation is a required property for SeededTrackedConversationEvent and cannot be null");
            }
            this.Conversation = conversation;
            this.Schema = schema;
            this.Metadata = metadata;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets IdentifierDescriptionPair
        /// </summary>
        [DataMember(Name = "identifier_description_pair", IsRequired = true, EmitDefaultValue = true)]
        public TrackedConversationEventIdentifierDescriptionPairs IdentifierDescriptionPair { get; set; }

        /// <summary>
        /// Gets or Sets Conversation
        /// </summary>
        [DataMember(Name = "conversation", IsRequired = true, EmitDefaultValue = true)]
        public ReferencedConversation Conversation { get; set; }

        /// <summary>
        /// Gets or Sets Metadata
        /// </summary>
        [DataMember(Name = "metadata", EmitDefaultValue = false)]
        public TrackedConversationEventMetadata Metadata { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class SeededTrackedConversationEvent {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  IdentifierDescriptionPair: ").Append(IdentifierDescriptionPair).Append("\n");
            sb.Append("  Conversation: ").Append(Conversation).Append("\n");
            sb.Append("  Metadata: ").Append(Metadata).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
