/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This seeded tracked asset event will be recieved by a context on the OS Server side, which will then be able to look up the asset id and structure the asset for shipment to Segment aka a fully built TrackedAssetEvent
    /// </summary>
    [DataContract(Name = "SeededTrackedAssetEvent")]
    public partial class SeededTrackedAssetEvent : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="SeededTrackedAssetEvent" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected SeededTrackedAssetEvent() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="SeededTrackedAssetEvent" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="asset">asset (required).</param>
        /// <param name="identifierDescriptionPair">identifierDescriptionPair (required).</param>
        /// <param name="metadata">metadata.</param>
        public SeededTrackedAssetEvent(EmbeddedModelSchema schema = default(EmbeddedModelSchema), ReferencedAsset asset = default(ReferencedAsset), TrackedAssetEventIdentifierDescriptionPairs identifierDescriptionPair = default(TrackedAssetEventIdentifierDescriptionPairs), TrackedAssetEventMetadata metadata = default(TrackedAssetEventMetadata))
        {
            // to ensure "asset" is required (not null)
            if (asset == null)
            {
                throw new ArgumentNullException("asset is a required property for SeededTrackedAssetEvent and cannot be null");
            }
            this.Asset = asset;
            // to ensure "identifierDescriptionPair" is required (not null)
            if (identifierDescriptionPair == null)
            {
                throw new ArgumentNullException("identifierDescriptionPair is a required property for SeededTrackedAssetEvent and cannot be null");
            }
            this.IdentifierDescriptionPair = identifierDescriptionPair;
            this.Schema = schema;
            this.Metadata = metadata;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Asset
        /// </summary>
        [DataMember(Name = "asset", IsRequired = true, EmitDefaultValue = true)]
        public ReferencedAsset Asset { get; set; }

        /// <summary>
        /// Gets or Sets IdentifierDescriptionPair
        /// </summary>
        [DataMember(Name = "identifier_description_pair", IsRequired = true, EmitDefaultValue = true)]
        public TrackedAssetEventIdentifierDescriptionPairs IdentifierDescriptionPair { get; set; }

        /// <summary>
        /// Gets or Sets Metadata
        /// </summary>
        [DataMember(Name = "metadata", EmitDefaultValue = false)]
        public TrackedAssetEventMetadata Metadata { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class SeededTrackedAssetEvent {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Asset: ").Append(Asset).Append("\n");
            sb.Append("  IdentifierDescriptionPair: ").Append(IdentifierDescriptionPair).Append("\n");
            sb.Append("  Metadata: ").Append(Metadata).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
