/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    ///  required to pass in an asset or assets.
    /// </summary>
    [DataContract(Name = "SeededShare")]
    public partial class SeededShare : IValidatableObject
    {

        /// <summary>
        /// Gets or Sets Access
        /// </summary>
        [DataMember(Name = "access", IsRequired = true, EmitDefaultValue = true)]
        public AccessEnum Access { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="SeededShare" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected SeededShare() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="SeededShare" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="asset">asset.</param>
        /// <param name="users">if private please specificy some users you want to share this with..</param>
        /// <param name="access">access (required).</param>
        /// <param name="assets">assets.</param>
        /// <param name="name">optional name, if it is available. and must be unique..</param>
        public SeededShare(EmbeddedModelSchema schema = default(EmbeddedModelSchema), Asset asset = default(Asset), List<SeededUser> users = default(List<SeededUser>), AccessEnum access = default(AccessEnum), Assets assets = default(Assets), string name = default(string))
        {
            this.Access = access;
            this.Schema = schema;
            this.Asset = asset;
            this.Users = users;
            this.Assets = assets;
            this.Name = name;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Asset
        /// </summary>
        [DataMember(Name = "asset", EmitDefaultValue = false)]
        public Asset Asset { get; set; }

        /// <summary>
        /// if private please specificy some users you want to share this with.
        /// </summary>
        /// <value>if private please specificy some users you want to share this with.</value>
        [DataMember(Name = "users", EmitDefaultValue = false)]
        public List<SeededUser> Users { get; set; }

        /// <summary>
        /// Gets or Sets Assets
        /// </summary>
        [DataMember(Name = "assets", EmitDefaultValue = false)]
        public Assets Assets { get; set; }

        /// <summary>
        /// optional name, if it is available. and must be unique.
        /// </summary>
        /// <value>optional name, if it is available. and must be unique.</value>
        [DataMember(Name = "name", EmitDefaultValue = false)]
        public string Name { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class SeededShare {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Asset: ").Append(Asset).Append("\n");
            sb.Append("  Users: ").Append(Users).Append("\n");
            sb.Append("  Access: ").Append(Access).Append("\n");
            sb.Append("  Assets: ").Append(Assets).Append("\n");
            sb.Append("  Name: ").Append(Name).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
