/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// Append any additional parameter to the end of your request, and it will be sent to the provider. For example, access_type&#x3D;offline (for Google Refresh Tokens) , display&#x3D;popup (for Windows Live popup mode).
    /// </summary>
    [DataContract(Name = "SeededPKCE_ADDITIONAL_PARAMETERS")]
    public partial class SeededPKCEADDITIONALPARAMETERS : IValidatableObject
    {
        /// <summary>
        /// Defines AccessType
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum AccessTypeEnum
        {
            /// <summary>
            /// Enum Offline for value: offline
            /// </summary>
            [EnumMember(Value = "offline")]
            Offline = 1
        }


        /// <summary>
        /// Gets or Sets AccessType
        /// </summary>
        [DataMember(Name = "access_type", EmitDefaultValue = false)]
        public AccessTypeEnum? AccessType { get; set; }
        /// <summary>
        /// Defines Display
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum DisplayEnum
        {
            /// <summary>
            /// Enum Popup for value: popup
            /// </summary>
            [EnumMember(Value = "popup")]
            Popup = 1
        }


        /// <summary>
        /// Gets or Sets Display
        /// </summary>
        [DataMember(Name = "display", EmitDefaultValue = false)]
        public DisplayEnum? Display { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="SeededPKCEADDITIONALPARAMETERS" /> class.
        /// </summary>
        /// <param name="accessType">accessType.</param>
        /// <param name="display">display.</param>
        public SeededPKCEADDITIONALPARAMETERS(AccessTypeEnum? accessType = default(AccessTypeEnum?), DisplayEnum? display = default(DisplayEnum?))
        {
            this.AccessType = accessType;
            this.Display = display;
        }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class SeededPKCEADDITIONALPARAMETERS {\n");
            sb.Append("  AccessType: ").Append(AccessType).Append("\n");
            sb.Append("  Display: ").Append(Display).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
