/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// A model that initialized a PKCE Authentication Flow.
    /// </summary>
    [DataContract(Name = "SeededPKCE")]
    public partial class SeededPKCE : IValidatableObject
    {
        /// <summary>
        /// Indicates to Auth0 which OAuth 2.0 Flow you want to perform. Use code for Authorization Code Grant (PKCE) Flow.
        /// </summary>
        /// <value>Indicates to Auth0 which OAuth 2.0 Flow you want to perform. Use code for Authorization Code Grant (PKCE) Flow.</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum ResponseTypeEnum
        {
            /// <summary>
            /// Enum Code for value: code
            /// </summary>
            [EnumMember(Value = "code")]
            Code = 1,

            /// <summary>
            /// Enum Token for value: token
            /// </summary>
            [EnumMember(Value = "token")]
            Token = 2,

            /// <summary>
            /// Enum IdToken for value: id_token
            /// </summary>
            [EnumMember(Value = "id_token")]
            IdToken = 3
        }


        /// <summary>
        /// Indicates to Auth0 which OAuth 2.0 Flow you want to perform. Use code for Authorization Code Grant (PKCE) Flow.
        /// </summary>
        /// <value>Indicates to Auth0 which OAuth 2.0 Flow you want to perform. Use code for Authorization Code Grant (PKCE) Flow.</value>
        /*
        <example>code</example>
        */
        [DataMember(Name = "response_type", IsRequired = true, EmitDefaultValue = true)]
        public ResponseTypeEnum ResponseType { get; set; }
        /// <summary>
        /// Method used to generate the challenge. The PKCE spec defines two methods, S256 and plain, however, Auth0 supports only S256 since the latter is discouraged.
        /// </summary>
        /// <value>Method used to generate the challenge. The PKCE spec defines two methods, S256 and plain, however, Auth0 supports only S256 since the latter is discouraged.</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum CodeChallengeMethodEnum
        {
            /// <summary>
            /// Enum S256 for value: S256
            /// </summary>
            [EnumMember(Value = "S256")]
            S256 = 1
        }


        /// <summary>
        /// Method used to generate the challenge. The PKCE spec defines two methods, S256 and plain, however, Auth0 supports only S256 since the latter is discouraged.
        /// </summary>
        /// <value>Method used to generate the challenge. The PKCE spec defines two methods, S256 and plain, however, Auth0 supports only S256 since the latter is discouraged.</value>
        [DataMember(Name = "code_challenge_method", IsRequired = true, EmitDefaultValue = true)]
        public CodeChallengeMethodEnum CodeChallengeMethod { get; set; }
        /// <summary>
        /// Provides a hint to Auth0 as to what flow should be displayed. The default behavior is to show a login page but you can override this by passing &#39;signup&#39; to show the signup page instead.
        /// </summary>
        /// <value>Provides a hint to Auth0 as to what flow should be displayed. The default behavior is to show a login page but you can override this by passing &#39;signup&#39; to show the signup page instead.</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum ScreenHintEnum
        {
            /// <summary>
            /// Enum Signup for value: signup
            /// </summary>
            [EnumMember(Value = "signup")]
            Signup = 1
        }


        /// <summary>
        /// Provides a hint to Auth0 as to what flow should be displayed. The default behavior is to show a login page but you can override this by passing &#39;signup&#39; to show the signup page instead.
        /// </summary>
        /// <value>Provides a hint to Auth0 as to what flow should be displayed. The default behavior is to show a login page but you can override this by passing &#39;signup&#39; to show the signup page instead.</value>
        [DataMember(Name = "screen_hint", EmitDefaultValue = false)]
        public ScreenHintEnum? ScreenHint { get; set; }
        /// <summary>
        ///  To initiate a silent authentication request, use prompt&#x3D;none (see Remarks for more info).
        /// </summary>
        /// <value> To initiate a silent authentication request, use prompt&#x3D;none (see Remarks for more info).</value>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum PromptEnum
        {
            /// <summary>
            /// Enum Login for value: login
            /// </summary>
            [EnumMember(Value = "login")]
            Login = 1,

            /// <summary>
            /// Enum None for value: none
            /// </summary>
            [EnumMember(Value = "none")]
            None = 2
        }


        /// <summary>
        ///  To initiate a silent authentication request, use prompt&#x3D;none (see Remarks for more info).
        /// </summary>
        /// <value> To initiate a silent authentication request, use prompt&#x3D;none (see Remarks for more info).</value>
        [DataMember(Name = "prompt", EmitDefaultValue = false)]
        public PromptEnum? Prompt { get; set; }
        /// <summary>
        /// Defines Scope
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum ScopeEnum
        {
            /// <summary>
            /// Enum OfflineAccess for value: offline_access
            /// </summary>
            [EnumMember(Value = "offline_access")]
            OfflineAccess = 1,

            /// <summary>
            /// Enum Email for value: email
            /// </summary>
            [EnumMember(Value = "email")]
            Email = 2,

            /// <summary>
            /// Enum Profile for value: profile
            /// </summary>
            [EnumMember(Value = "profile")]
            Profile = 3,

            /// <summary>
            /// Enum Openid for value: openid
            /// </summary>
            [EnumMember(Value = "openid")]
            Openid = 4
        }

        /// <summary>
        /// Defines ResponseMode
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum ResponseModeEnum
        {
            /// <summary>
            /// Enum FormPost for value: form_post
            /// </summary>
            [EnumMember(Value = "form_post")]
            FormPost = 1,

            /// <summary>
            /// Enum WebMessage for value: web_message
            /// </summary>
            [EnumMember(Value = "web_message")]
            WebMessage = 2,

            /// <summary>
            /// Enum Fragment for value: fragment
            /// </summary>
            [EnumMember(Value = "fragment")]
            Fragment = 3,

            /// <summary>
            /// Enum Query for value: query
            /// </summary>
            [EnumMember(Value = "query")]
            Query = 4
        }


        /// <summary>
        /// Gets or Sets ResponseMode
        /// </summary>
        [DataMember(Name = "response_mode", EmitDefaultValue = false)]
        public ResponseModeEnum? ResponseMode { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="SeededPKCE" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected SeededPKCE() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="SeededPKCE" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="responseType">Indicates to Auth0 which OAuth 2.0 Flow you want to perform. Use code for Authorization Code Grant (PKCE) Flow. (required).</param>
        /// <param name="state">An opaque value the clients adds to the initial request that Auth0 includes when redirecting the back to the client. This value must be used by the client to prevent CSRF attacks. (required).</param>
        /// <param name="nonce">A local key that is held as the comparator to state, thus they should be the same. (required).</param>
        /// <param name="redirectUri">http://localhost:8080/authentication/response.</param>
        /// <param name="codeChallenge">Generated challenge from the code_verifier. (required).</param>
        /// <param name="codeChallengeMethod">Method used to generate the challenge. The PKCE spec defines two methods, S256 and plain, however, Auth0 supports only S256 since the latter is discouraged. (required).</param>
        /// <param name="domain">https://auth.pieces.services/authorize.</param>
        /// <param name="audience">The unique identifier of the target API you want to access. i.e. https://pieces.us.auth0.com/api/v2/.</param>
        /// <param name="screenHint">Provides a hint to Auth0 as to what flow should be displayed. The default behavior is to show a login page but you can override this by passing &#39;signup&#39; to show the signup page instead..</param>
        /// <param name="prompt"> To initiate a silent authentication request, use prompt&#x3D;none (see Remarks for more info)..</param>
        /// <param name="organization">organization.</param>
        /// <param name="invitation">invitation.</param>
        /// <param name="scope">The scopes which you want to request authorization for. These must be separated by a space. You can request any of the standard OpenID Connect (OIDC) scopes about users, such as profile and email, custom claims that must conform to a namespaced format, or any scopes supported by the target API (for example, read:contacts). Include offline_access to get a Refresh Token. (required).</param>
        /// <param name="clientId">Your application&#39;s Client ID. (required).</param>
        /// <param name="aDDITIONALPARAMETERS">aDDITIONALPARAMETERS.</param>
        /// <param name="responseMode">responseMode.</param>
        public SeededPKCE(EmbeddedModelSchema schema = default(EmbeddedModelSchema), ResponseTypeEnum responseType = default(ResponseTypeEnum), Guid state = default(Guid), Guid nonce = default(Guid), string redirectUri = default(string), string codeChallenge = default(string), CodeChallengeMethodEnum codeChallengeMethod = default(CodeChallengeMethodEnum), string domain = default(string), string audience = default(string), ScreenHintEnum? screenHint = default(ScreenHintEnum?), PromptEnum? prompt = default(PromptEnum?), string organization = default(string), string invitation = default(string), List<ScopeEnum> scope = default(List<ScopeEnum>), string clientId = default(string), SeededPKCEADDITIONALPARAMETERS aDDITIONALPARAMETERS = default(SeededPKCEADDITIONALPARAMETERS), ResponseModeEnum? responseMode = default(ResponseModeEnum?))
        {
            this.ResponseType = responseType;
            this.State = state;
            this.Nonce = nonce;
            // to ensure "codeChallenge" is required (not null)
            if (codeChallenge == null)
            {
                throw new ArgumentNullException("codeChallenge is a required property for SeededPKCE and cannot be null");
            }
            this.CodeChallenge = codeChallenge;
            this.CodeChallengeMethod = codeChallengeMethod;
            // to ensure "scope" is required (not null)
            if (scope == null)
            {
                throw new ArgumentNullException("scope is a required property for SeededPKCE and cannot be null");
            }
            this.Scope = scope;
            // to ensure "clientId" is required (not null)
            if (clientId == null)
            {
                throw new ArgumentNullException("clientId is a required property for SeededPKCE and cannot be null");
            }
            this.ClientId = clientId;
            this.Schema = schema;
            this.RedirectUri = redirectUri;
            this.Domain = domain;
            this.Audience = audience;
            this.ScreenHint = screenHint;
            this.Prompt = prompt;
            this.Organization = organization;
            this.Invitation = invitation;
            this.ADDITIONAL_PARAMETERS = aDDITIONALPARAMETERS;
            this.ResponseMode = responseMode;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// An opaque value the clients adds to the initial request that Auth0 includes when redirecting the back to the client. This value must be used by the client to prevent CSRF attacks.
        /// </summary>
        /// <value>An opaque value the clients adds to the initial request that Auth0 includes when redirecting the back to the client. This value must be used by the client to prevent CSRF attacks.</value>
        [DataMember(Name = "state", IsRequired = true, EmitDefaultValue = true)]
        public Guid State { get; set; }

        /// <summary>
        /// A local key that is held as the comparator to state, thus they should be the same.
        /// </summary>
        /// <value>A local key that is held as the comparator to state, thus they should be the same.</value>
        [DataMember(Name = "nonce", IsRequired = true, EmitDefaultValue = true)]
        public Guid Nonce { get; set; }

        /// <summary>
        /// http://localhost:8080/authentication/response
        /// </summary>
        /// <value>http://localhost:8080/authentication/response</value>
        [DataMember(Name = "redirect_uri", EmitDefaultValue = false)]
        public string RedirectUri { get; set; }

        /// <summary>
        /// Generated challenge from the code_verifier.
        /// </summary>
        /// <value>Generated challenge from the code_verifier.</value>
        [DataMember(Name = "code_challenge", IsRequired = true, EmitDefaultValue = true)]
        public string CodeChallenge { get; set; }

        /// <summary>
        /// https://auth.pieces.services/authorize
        /// </summary>
        /// <value>https://auth.pieces.services/authorize</value>
        [DataMember(Name = "domain", EmitDefaultValue = false)]
        public string Domain { get; set; }

        /// <summary>
        /// The unique identifier of the target API you want to access. i.e. https://pieces.us.auth0.com/api/v2/
        /// </summary>
        /// <value>The unique identifier of the target API you want to access. i.e. https://pieces.us.auth0.com/api/v2/</value>
        [DataMember(Name = "audience", EmitDefaultValue = false)]
        public string Audience { get; set; }

        /// <summary>
        /// Gets or Sets Organization
        /// </summary>
        [DataMember(Name = "organization", EmitDefaultValue = false)]
        public string Organization { get; set; }

        /// <summary>
        /// Gets or Sets Invitation
        /// </summary>
        [DataMember(Name = "invitation", EmitDefaultValue = false)]
        public string Invitation { get; set; }

        /// <summary>
        /// The scopes which you want to request authorization for. These must be separated by a space. You can request any of the standard OpenID Connect (OIDC) scopes about users, such as profile and email, custom claims that must conform to a namespaced format, or any scopes supported by the target API (for example, read:contacts). Include offline_access to get a Refresh Token.
        /// </summary>
        /// <value>The scopes which you want to request authorization for. These must be separated by a space. You can request any of the standard OpenID Connect (OIDC) scopes about users, such as profile and email, custom claims that must conform to a namespaced format, or any scopes supported by the target API (for example, read:contacts). Include offline_access to get a Refresh Token.</value>
        [DataMember(Name = "scope", IsRequired = true, EmitDefaultValue = true)]
        public List<SeededPKCE.ScopeEnum> Scope { get; set; }

        /// <summary>
        /// Your application&#39;s Client ID.
        /// </summary>
        /// <value>Your application&#39;s Client ID.</value>
        /*
        <example>9sW4Pa1LEjX67l6VO14u0207NLYeXnu1</example>
        */
        [DataMember(Name = "client_id", IsRequired = true, EmitDefaultValue = true)]
        public string ClientId { get; set; }

        /// <summary>
        /// Gets or Sets ADDITIONAL_PARAMETERS
        /// </summary>
        [DataMember(Name = "ADDITIONAL_PARAMETERS", EmitDefaultValue = false)]
        public SeededPKCEADDITIONALPARAMETERS ADDITIONAL_PARAMETERS { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class SeededPKCE {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  ResponseType: ").Append(ResponseType).Append("\n");
            sb.Append("  State: ").Append(State).Append("\n");
            sb.Append("  Nonce: ").Append(Nonce).Append("\n");
            sb.Append("  RedirectUri: ").Append(RedirectUri).Append("\n");
            sb.Append("  CodeChallenge: ").Append(CodeChallenge).Append("\n");
            sb.Append("  CodeChallengeMethod: ").Append(CodeChallengeMethod).Append("\n");
            sb.Append("  Domain: ").Append(Domain).Append("\n");
            sb.Append("  Audience: ").Append(Audience).Append("\n");
            sb.Append("  ScreenHint: ").Append(ScreenHint).Append("\n");
            sb.Append("  Prompt: ").Append(Prompt).Append("\n");
            sb.Append("  Organization: ").Append(Organization).Append("\n");
            sb.Append("  Invitation: ").Append(Invitation).Append("\n");
            sb.Append("  Scope: ").Append(Scope).Append("\n");
            sb.Append("  ClientId: ").Append(ClientId).Append("\n");
            sb.Append("  ADDITIONAL_PARAMETERS: ").Append(ADDITIONAL_PARAMETERS).Append("\n");
            sb.Append("  ResponseMode: ").Append(ResponseMode).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
