/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// An Seeded Asset specific to MacOS which takes in a Value, and Application
    /// </summary>
    [DataContract(Name = "SeededMacOSAsset")]
    public partial class SeededMacOSAsset : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="SeededMacOSAsset" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected SeededMacOSAsset() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="SeededMacOSAsset" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="application">application.</param>
        /// <param name="value">The value of the text that you want to save as an asset. (required).</param>
        public SeededMacOSAsset(EmbeddedModelSchema schema = default(EmbeddedModelSchema), Application application = default(Application), string value = default(string))
        {
            // to ensure "value" is required (not null)
            if (value == null)
            {
                throw new ArgumentNullException("value is a required property for SeededMacOSAsset and cannot be null");
            }
            this.Value = value;
            this.Schema = schema;
            this.Application = application;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Application
        /// </summary>
        [DataMember(Name = "application", EmitDefaultValue = false)]
        public Application Application { get; set; }

        /// <summary>
        /// The value of the text that you want to save as an asset.
        /// </summary>
        /// <value>The value of the text that you want to save as an asset.</value>
        /*
        <example>console.log(&quot;hello world&quot;)</example>
        */
        [DataMember(Name = "value", IsRequired = true, EmitDefaultValue = true)]
        public string Value { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class SeededMacOSAsset {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Application: ").Append(Application).Append("\n");
            sb.Append("  Value: ").Append(Value).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
