/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// SeededHint
    /// </summary>
    [DataContract(Name = "SeededHint")]
    public partial class SeededHint : IValidatableObject
    {

        /// <summary>
        /// Gets or Sets Mechanism
        /// </summary>
        [DataMember(Name = "mechanism", EmitDefaultValue = false)]
        public MechanismEnum? Mechanism { get; set; }

        /// <summary>
        /// Gets or Sets Type
        /// </summary>
        [DataMember(Name = "type", IsRequired = true, EmitDefaultValue = true)]
        public HintTypeEnum Type { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="SeededHint" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected SeededHint() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="SeededHint" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="mechanism">mechanism.</param>
        /// <param name="asset">This is an asset id that we are using to link this to an asset..</param>
        /// <param name="type">type (required).</param>
        /// <param name="text">This is the text of the hint. (required).</param>
        /// <param name="model">this is a model id. that we are using to link this to a model..</param>
        public SeededHint(EmbeddedModelSchema schema = default(EmbeddedModelSchema), MechanismEnum? mechanism = default(MechanismEnum?), string asset = default(string), HintTypeEnum type = default(HintTypeEnum), string text = default(string), string model = default(string))
        {
            this.Type = type;
            // to ensure "text" is required (not null)
            if (text == null)
            {
                throw new ArgumentNullException("text is a required property for SeededHint and cannot be null");
            }
            this.Text = text;
            this.Schema = schema;
            this.Mechanism = mechanism;
            this.Asset = asset;
            this.Model = model;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// This is an asset id that we are using to link this to an asset.
        /// </summary>
        /// <value>This is an asset id that we are using to link this to an asset.</value>
        [DataMember(Name = "asset", EmitDefaultValue = false)]
        public string Asset { get; set; }

        /// <summary>
        /// This is the text of the hint.
        /// </summary>
        /// <value>This is the text of the hint.</value>
        [DataMember(Name = "text", IsRequired = true, EmitDefaultValue = true)]
        public string Text { get; set; }

        /// <summary>
        /// this is a model id. that we are using to link this to a model.
        /// </summary>
        /// <value>this is a model id. that we are using to link this to a model.</value>
        [DataMember(Name = "model", EmitDefaultValue = false)]
        public string Model { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class SeededHint {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Mechanism: ").Append(Mechanism).Append("\n");
            sb.Append("  Asset: ").Append(Asset).Append("\n");
            sb.Append("  Type: ").Append(Type).Append("\n");
            sb.Append("  Text: ").Append(Text).Append("\n");
            sb.Append("  Model: ").Append(Model).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
