/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is the body of the /github/gists/import,  by default we will look for everything from your private gists, (TODO hook up public gists.)&amp;&amp; get clever  currently we will not ensure that this is a good pieces for you but we will just get you the gist and let you do what you want with it(room for improvement, if we want to layer in advanced pieces discovery)  For the future, we might want to add a max number of assets that are returned from this.
    /// </summary>
    [DataContract(Name = "SeededGithubGistsImport")]
    public partial class SeededGithubGistsImport : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="SeededGithubGistsImport" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected SeededGithubGistsImport() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="SeededGithubGistsImport" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="application">application id. (required).</param>
        /// <param name="varPublic">This will default to false.(ie private), currently not supporting pulling public gists..</param>
        public SeededGithubGistsImport(EmbeddedModelSchema schema = default(EmbeddedModelSchema), string application = default(string), bool varPublic = default(bool))
        {
            // to ensure "application" is required (not null)
            if (application == null)
            {
                throw new ArgumentNullException("application is a required property for SeededGithubGistsImport and cannot be null");
            }
            this.Application = application;
            this.Schema = schema;
            this.Public = varPublic;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// application id.
        /// </summary>
        /// <value>application id.</value>
        [DataMember(Name = "application", IsRequired = true, EmitDefaultValue = true)]
        public string Application { get; set; }

        /// <summary>
        /// This will default to false.(ie private), currently not supporting pulling public gists.
        /// </summary>
        /// <value>This will default to false.(ie private), currently not supporting pulling public gists.</value>
        [DataMember(Name = "public", EmitDefaultValue = true)]
        public bool Public { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class SeededGithubGistsImport {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Application: ").Append(Application).Append("\n");
            sb.Append("  Public: ").Append(Public).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
