/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is the minimum information needed to distribute a Piece to a Gist.
    /// </summary>
    [DataContract(Name = "SeededGitHubGistDistribution")]
    public partial class SeededGitHubGistDistribution : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="SeededGitHubGistDistribution" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected SeededGitHubGistDistribution() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="SeededGitHubGistDistribution" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="recipients">recipients.</param>
        /// <param name="varPublic">we will default to true.</param>
        /// <param name="description">This is the description of the Gist Distribution.</param>
        /// <param name="name">This is the name of the gist you will add. (required).</param>
        public SeededGitHubGistDistribution(EmbeddedModelSchema schema = default(EmbeddedModelSchema), Recipients recipients = default(Recipients), bool varPublic = default(bool), string description = default(string), string name = default(string))
        {
            // to ensure "name" is required (not null)
            if (name == null)
            {
                throw new ArgumentNullException("name is a required property for SeededGitHubGistDistribution and cannot be null");
            }
            this.Name = name;
            this.Schema = schema;
            this.Recipients = recipients;
            this.Public = varPublic;
            this.Description = description;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Recipients
        /// </summary>
        [DataMember(Name = "recipients", EmitDefaultValue = false)]
        public Recipients Recipients { get; set; }

        /// <summary>
        /// we will default to true
        /// </summary>
        /// <value>we will default to true</value>
        [DataMember(Name = "public", EmitDefaultValue = true)]
        public bool Public { get; set; }

        /// <summary>
        /// This is the description of the Gist Distribution
        /// </summary>
        /// <value>This is the description of the Gist Distribution</value>
        [DataMember(Name = "description", EmitDefaultValue = false)]
        public string Description { get; set; }

        /// <summary>
        /// This is the name of the gist you will add.
        /// </summary>
        /// <value>This is the name of the gist you will add.</value>
        [DataMember(Name = "name", IsRequired = true, EmitDefaultValue = true)]
        public string Name { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class SeededGitHubGistDistribution {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Recipients: ").Append(Recipients).Append("\n");
            sb.Append("  Public: ").Append(Public).Append("\n");
            sb.Append("  Description: ").Append(Description).Append("\n");
            sb.Append("  Name: ").Append(Name).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
