/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// SeededDiscoverableRelatedTag
    /// </summary>
    [DataContract(Name = "SeededDiscoverableRelatedTag")]
    public partial class SeededDiscoverableRelatedTag : IValidatableObject
    {

        /// <summary>
        /// Gets or Sets Mechanism
        /// </summary>
        [DataMember(Name = "mechanism", EmitDefaultValue = false)]
        public MechanismEnum? Mechanism { get; set; }

        /// <summary>
        /// Gets or Sets Category
        /// </summary>
        [DataMember(Name = "category", EmitDefaultValue = false)]
        public TagCategoryEnum? Category { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="SeededDiscoverableRelatedTag" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected SeededDiscoverableRelatedTag() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="SeededDiscoverableRelatedTag" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="text">This is the description of the tag. (required).</param>
        /// <param name="asset">this is a uuid that references an asset. (required).</param>
        /// <param name="mechanism">mechanism.</param>
        /// <param name="format">(optionally) you can attach a tag to a format. so when you delete a format this tag will get removed from the asset as well..</param>
        /// <param name="category">category.</param>
        public SeededDiscoverableRelatedTag(EmbeddedModelSchema schema = default(EmbeddedModelSchema), string text = default(string), string asset = default(string), MechanismEnum? mechanism = default(MechanismEnum?), string format = default(string), TagCategoryEnum? category = default(TagCategoryEnum?))
        {
            // to ensure "text" is required (not null)
            if (text == null)
            {
                throw new ArgumentNullException("text is a required property for SeededDiscoverableRelatedTag and cannot be null");
            }
            this.Text = text;
            // to ensure "asset" is required (not null)
            if (asset == null)
            {
                throw new ArgumentNullException("asset is a required property for SeededDiscoverableRelatedTag and cannot be null");
            }
            this.Asset = asset;
            this.Schema = schema;
            this.Mechanism = mechanism;
            this.Format = format;
            this.Category = category;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// This is the description of the tag.
        /// </summary>
        /// <value>This is the description of the tag.</value>
        [DataMember(Name = "text", IsRequired = true, EmitDefaultValue = true)]
        public string Text { get; set; }

        /// <summary>
        /// this is a uuid that references an asset.
        /// </summary>
        /// <value>this is a uuid that references an asset.</value>
        [DataMember(Name = "asset", IsRequired = true, EmitDefaultValue = true)]
        public string Asset { get; set; }

        /// <summary>
        /// (optionally) you can attach a tag to a format. so when you delete a format this tag will get removed from the asset as well.
        /// </summary>
        /// <value>(optionally) you can attach a tag to a format. so when you delete a format this tag will get removed from the asset as well.</value>
        [DataMember(Name = "format", EmitDefaultValue = false)]
        public string Format { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class SeededDiscoverableRelatedTag {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Text: ").Append(Text).Append("\n");
            sb.Append("  Asset: ").Append(Asset).Append("\n");
            sb.Append("  Mechanism: ").Append(Mechanism).Append("\n");
            sb.Append("  Format: ").Append(Format).Append("\n");
            sb.Append("  Category: ").Append(Category).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
