/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// SeededDiscoverableHtmlWebpage
    /// </summary>
    [DataContract(Name = "SeededDiscoverableHtmlWebpage")]
    public partial class SeededDiscoverableHtmlWebpage : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="SeededDiscoverableHtmlWebpage" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected SeededDiscoverableHtmlWebpage() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="SeededDiscoverableHtmlWebpage" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="url">The route of the page  (required).</param>
        /// <param name="page">page&#39;s html as a string (required).</param>
        public SeededDiscoverableHtmlWebpage(EmbeddedModelSchema schema = default(EmbeddedModelSchema), string url = default(string), string page = default(string))
        {
            // to ensure "url" is required (not null)
            if (url == null)
            {
                throw new ArgumentNullException("url is a required property for SeededDiscoverableHtmlWebpage and cannot be null");
            }
            this.Url = url;
            // to ensure "page" is required (not null)
            if (page == null)
            {
                throw new ArgumentNullException("page is a required property for SeededDiscoverableHtmlWebpage and cannot be null");
            }
            this.Page = page;
            this.Schema = schema;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// The route of the page 
        /// </summary>
        /// <value>The route of the page </value>
        [DataMember(Name = "url", IsRequired = true, EmitDefaultValue = true)]
        public string Url { get; set; }

        /// <summary>
        /// page&#39;s html as a string
        /// </summary>
        /// <value>page&#39;s html as a string</value>
        [DataMember(Name = "page", IsRequired = true, EmitDefaultValue = true)]
        public string Page { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class SeededDiscoverableHtmlWebpage {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Url: ").Append(Url).Append("\n");
            sb.Append("  Page: ").Append(Page).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
