/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is a seeded version of a ConversationMessage.  conversation is optional, this is because it can be used within the SeededConversation, however if this is passed into the /messages/create w/o a conversation uuid then we will throw an error.
    /// </summary>
    [DataContract(Name = "SeededConversationMessage")]
    public partial class SeededConversationMessage : IValidatableObject
    {

        /// <summary>
        /// Gets or Sets Sentiment
        /// </summary>
        [DataMember(Name = "sentiment", EmitDefaultValue = false)]
        public ConversationMessageSentimentEnum? Sentiment { get; set; }

        /// <summary>
        /// Gets or Sets Role
        /// </summary>
        [DataMember(Name = "role", IsRequired = true, EmitDefaultValue = true)]
        public QGPTConversationMessageRoleEnum Role { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="SeededConversationMessage" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected SeededConversationMessage() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="SeededConversationMessage" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="created">created.</param>
        /// <param name="model">model.</param>
        /// <param name="fragment">fragment (required).</param>
        /// <param name="conversation">conversation.</param>
        /// <param name="sentiment">sentiment.</param>
        /// <param name="role">role (required).</param>
        public SeededConversationMessage(EmbeddedModelSchema schema = default(EmbeddedModelSchema), GroupedTimestamp created = default(GroupedTimestamp), Model model = default(Model), FragmentFormat fragment = default(FragmentFormat), ReferencedConversation conversation = default(ReferencedConversation), ConversationMessageSentimentEnum? sentiment = default(ConversationMessageSentimentEnum?), QGPTConversationMessageRoleEnum role = default(QGPTConversationMessageRoleEnum))
        {
            // to ensure "fragment" is required (not null)
            if (fragment == null)
            {
                throw new ArgumentNullException("fragment is a required property for SeededConversationMessage and cannot be null");
            }
            this.Fragment = fragment;
            this.Role = role;
            this.Schema = schema;
            this.Created = created;
            this.Model = model;
            this.Conversation = conversation;
            this.Sentiment = sentiment;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Created
        /// </summary>
        [DataMember(Name = "created", EmitDefaultValue = false)]
        public GroupedTimestamp Created { get; set; }

        /// <summary>
        /// Gets or Sets Model
        /// </summary>
        [DataMember(Name = "model", EmitDefaultValue = false)]
        public Model Model { get; set; }

        /// <summary>
        /// Gets or Sets Fragment
        /// </summary>
        [DataMember(Name = "fragment", IsRequired = true, EmitDefaultValue = true)]
        public FragmentFormat Fragment { get; set; }

        /// <summary>
        /// Gets or Sets Conversation
        /// </summary>
        [DataMember(Name = "conversation", EmitDefaultValue = false)]
        public ReferencedConversation Conversation { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class SeededConversationMessage {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Created: ").Append(Created).Append("\n");
            sb.Append("  Model: ").Append(Model).Append("\n");
            sb.Append("  Fragment: ").Append(Fragment).Append("\n");
            sb.Append("  Conversation: ").Append(Conversation).Append("\n");
            sb.Append("  Sentiment: ").Append(Sentiment).Append("\n");
            sb.Append("  Role: ").Append(Role).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
