/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This model is designed to be light weight and low friction while most of the heavy lifting will be happening inside of the context servers.  This Model is important because this has references to our materials, instead of fully referenced materials.(very similar to our SeededTrackedEvent, consider consolidating and converting these to Referenced models instead of ID&#39;s)
    /// </summary>
    [DataContract(Name = "SeededConnectorTracking")]
    public partial class SeededConnectorTracking : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="SeededConnectorTracking" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="format">format.</param>
        /// <param name="asset">asset.</param>
        /// <param name="interaction">interaction.</param>
        /// <param name="keyboard">keyboard.</param>
        /// <param name="session">session.</param>
        /// <param name="assets">assets.</param>
        /// <param name="ml">ml.</param>
        /// <param name="adoption">adoption.</param>
        /// <param name="conversation">conversation.</param>
        public SeededConnectorTracking(EmbeddedModelSchema schema = default(EmbeddedModelSchema), SeededTrackedFormatEvent format = default(SeededTrackedFormatEvent), SeededTrackedAssetEvent asset = default(SeededTrackedAssetEvent), SeededTrackedInteractionEvent interaction = default(SeededTrackedInteractionEvent), SeededTrackedKeyboardEvent keyboard = default(SeededTrackedKeyboardEvent), SeededTrackedSessionEvent session = default(SeededTrackedSessionEvent), SeededTrackedAssetsEvent assets = default(SeededTrackedAssetsEvent), SeededTrackedMachineLearningEvent ml = default(SeededTrackedMachineLearningEvent), SeededTrackedAdoptionEvent adoption = default(SeededTrackedAdoptionEvent), SeededTrackedConversationEvent conversation = default(SeededTrackedConversationEvent))
        {
            this.Schema = schema;
            this.Format = format;
            this.Asset = asset;
            this.Interaction = interaction;
            this.Keyboard = keyboard;
            this.Session = session;
            this.Assets = assets;
            this.Ml = ml;
            this.Adoption = adoption;
            this.Conversation = conversation;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Format
        /// </summary>
        [DataMember(Name = "format", EmitDefaultValue = false)]
        public SeededTrackedFormatEvent Format { get; set; }

        /// <summary>
        /// Gets or Sets Asset
        /// </summary>
        [DataMember(Name = "asset", EmitDefaultValue = false)]
        public SeededTrackedAssetEvent Asset { get; set; }

        /// <summary>
        /// Gets or Sets Interaction
        /// </summary>
        [DataMember(Name = "interaction", EmitDefaultValue = false)]
        public SeededTrackedInteractionEvent Interaction { get; set; }

        /// <summary>
        /// Gets or Sets Keyboard
        /// </summary>
        [DataMember(Name = "keyboard", EmitDefaultValue = false)]
        public SeededTrackedKeyboardEvent Keyboard { get; set; }

        /// <summary>
        /// Gets or Sets Session
        /// </summary>
        [DataMember(Name = "session", EmitDefaultValue = false)]
        public SeededTrackedSessionEvent Session { get; set; }

        /// <summary>
        /// Gets or Sets Assets
        /// </summary>
        [DataMember(Name = "assets", EmitDefaultValue = false)]
        public SeededTrackedAssetsEvent Assets { get; set; }

        /// <summary>
        /// Gets or Sets Ml
        /// </summary>
        [DataMember(Name = "ml", EmitDefaultValue = false)]
        public SeededTrackedMachineLearningEvent Ml { get; set; }

        /// <summary>
        /// Gets or Sets Adoption
        /// </summary>
        [DataMember(Name = "adoption", EmitDefaultValue = false)]
        public SeededTrackedAdoptionEvent Adoption { get; set; }

        /// <summary>
        /// Gets or Sets Conversation
        /// </summary>
        [DataMember(Name = "conversation", EmitDefaultValue = false)]
        public SeededTrackedConversationEvent Conversation { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class SeededConnectorTracking {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Format: ").Append(Format).Append("\n");
            sb.Append("  Asset: ").Append(Asset).Append("\n");
            sb.Append("  Interaction: ").Append(Interaction).Append("\n");
            sb.Append("  Keyboard: ").Append(Keyboard).Append("\n");
            sb.Append("  Session: ").Append(Session).Append("\n");
            sb.Append("  Assets: ").Append(Assets).Append("\n");
            sb.Append("  Ml: ").Append(Ml).Append("\n");
            sb.Append("  Adoption: ").Append(Adoption).Append("\n");
            sb.Append("  Conversation: ").Append(Conversation).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
