/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is optional metadata sent with the SeededAsset and other SeededAssets ie (UE, Jetbrains...)  Note: if a user/develop didnt explicitly state a mechanism we will default to manual(user Driven only)
    /// </summary>
    [DataContract(Name = "SeededAssetMetadata")]
    public partial class SeededAssetMetadata : IValidatableObject
    {

        /// <summary>
        /// Gets or Sets Mechanism
        /// </summary>
        [DataMember(Name = "mechanism", EmitDefaultValue = false)]
        public MechanismEnum? Mechanism { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="SeededAssetMetadata" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="name">This is the name of the asset..</param>
        /// <param name="mechanism">mechanism.</param>
        /// <param name="tags">(optional) can add some tags to associate to this asset..</param>
        /// <param name="websites">websites.</param>
        /// <param name="sensitives">sensitives.</param>
        /// <param name="persons">persons.</param>
        /// <param name="annotations">annotations.</param>
        /// <param name="hints">hints.</param>
        /// <param name="anchors">anchors.</param>
        public SeededAssetMetadata(EmbeddedModelSchema schema = default(EmbeddedModelSchema), string name = default(string), MechanismEnum? mechanism = default(MechanismEnum?), List<SeededAssetTag> tags = default(List<SeededAssetTag>), List<SeededAssetWebsite> websites = default(List<SeededAssetWebsite>), List<SeededAssetSensitive> sensitives = default(List<SeededAssetSensitive>), List<SeededPerson> persons = default(List<SeededPerson>), List<SeededAnnotation> annotations = default(List<SeededAnnotation>), List<SeededHint> hints = default(List<SeededHint>), List<SeededAnchor> anchors = default(List<SeededAnchor>))
        {
            this.Schema = schema;
            this.Name = name;
            this.Mechanism = mechanism;
            this.Tags = tags;
            this.Websites = websites;
            this.Sensitives = sensitives;
            this.Persons = persons;
            this.Annotations = annotations;
            this.Hints = hints;
            this.Anchors = anchors;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// This is the name of the asset.
        /// </summary>
        /// <value>This is the name of the asset.</value>
        [DataMember(Name = "name", EmitDefaultValue = false)]
        public string Name { get; set; }

        /// <summary>
        /// (optional) can add some tags to associate to this asset.
        /// </summary>
        /// <value>(optional) can add some tags to associate to this asset.</value>
        [DataMember(Name = "tags", EmitDefaultValue = false)]
        public List<SeededAssetTag> Tags { get; set; }

        /// <summary>
        /// Gets or Sets Websites
        /// </summary>
        [DataMember(Name = "websites", EmitDefaultValue = false)]
        public List<SeededAssetWebsite> Websites { get; set; }

        /// <summary>
        /// Gets or Sets Sensitives
        /// </summary>
        [DataMember(Name = "sensitives", EmitDefaultValue = false)]
        public List<SeededAssetSensitive> Sensitives { get; set; }

        /// <summary>
        /// Gets or Sets Persons
        /// </summary>
        [DataMember(Name = "persons", EmitDefaultValue = false)]
        public List<SeededPerson> Persons { get; set; }

        /// <summary>
        /// Gets or Sets Annotations
        /// </summary>
        [DataMember(Name = "annotations", EmitDefaultValue = false)]
        public List<SeededAnnotation> Annotations { get; set; }

        /// <summary>
        /// Gets or Sets Hints
        /// </summary>
        [DataMember(Name = "hints", EmitDefaultValue = false)]
        public List<SeededHint> Hints { get; set; }

        /// <summary>
        /// Gets or Sets Anchors
        /// </summary>
        [DataMember(Name = "anchors", EmitDefaultValue = false)]
        public List<SeededAnchor> Anchors { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class SeededAssetMetadata {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Name: ").Append(Name).Append("\n");
            sb.Append("  Mechanism: ").Append(Mechanism).Append("\n");
            sb.Append("  Tags: ").Append(Tags).Append("\n");
            sb.Append("  Websites: ").Append(Websites).Append("\n");
            sb.Append("  Sensitives: ").Append(Sensitives).Append("\n");
            sb.Append("  Persons: ").Append(Persons).Append("\n");
            sb.Append("  Annotations: ").Append(Annotations).Append("\n");
            sb.Append("  Hints: ").Append(Hints).Append("\n");
            sb.Append("  Anchors: ").Append(Anchors).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
