/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is seed data that will be come an asset.  discovered: if set to true this seededAsset was discovered using one of our discovery endpoints.  pseudo: if this is an asset that a user did NOT explicitly save.  available: This is a model that is used within our &#39;/assets/draft&#39; endpoint that will emitt a seed with all the available format that one can generate based on the original seed that was passed in. ie if a png was passed in, we may  say that there is a text/code format available. If available formats is passed into the &#39;/assets/create&#39; we will short curcuit certain operations to speed up the process, for instance, if we determine that there is no text within this image then there is no sense in running ocr. 
    /// </summary>
    [DataContract(Name = "SeededAsset")]
    public partial class SeededAsset : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="SeededAsset" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected SeededAsset() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="SeededAsset" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="metadata">metadata.</param>
        /// <param name="application">application (required).</param>
        /// <param name="format">format (required).</param>
        /// <param name="discovered">discovered.</param>
        /// <param name="available">available.</param>
        /// <param name="pseudo">pseudo.</param>
        /// <param name="enrichment">enrichment.</param>
        /// <param name="demo">This will let us know if this asset was generated as a &#39;demo&#39; snippet.</param>
        public SeededAsset(EmbeddedModelSchema schema = default(EmbeddedModelSchema), SeededAssetMetadata metadata = default(SeededAssetMetadata), Application application = default(Application), SeededFormat format = default(SeededFormat), bool discovered = default(bool), AvailableFormats available = default(AvailableFormats), bool pseudo = default(bool), SeededAssetEnrichment enrichment = default(SeededAssetEnrichment), bool demo = default(bool))
        {
            // to ensure "application" is required (not null)
            if (application == null)
            {
                throw new ArgumentNullException("application is a required property for SeededAsset and cannot be null");
            }
            this.Application = application;
            // to ensure "format" is required (not null)
            if (format == null)
            {
                throw new ArgumentNullException("format is a required property for SeededAsset and cannot be null");
            }
            this.Format = format;
            this.Schema = schema;
            this.Metadata = metadata;
            this.Discovered = discovered;
            this.Available = available;
            this.Pseudo = pseudo;
            this.Enrichment = enrichment;
            this.Demo = demo;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Metadata
        /// </summary>
        [DataMember(Name = "metadata", EmitDefaultValue = false)]
        public SeededAssetMetadata Metadata { get; set; }

        /// <summary>
        /// Gets or Sets Application
        /// </summary>
        [DataMember(Name = "application", IsRequired = true, EmitDefaultValue = true)]
        public Application Application { get; set; }

        /// <summary>
        /// Gets or Sets Format
        /// </summary>
        [DataMember(Name = "format", IsRequired = true, EmitDefaultValue = true)]
        public SeededFormat Format { get; set; }

        /// <summary>
        /// Gets or Sets Discovered
        /// </summary>
        [DataMember(Name = "discovered", EmitDefaultValue = true)]
        public bool Discovered { get; set; }

        /// <summary>
        /// Gets or Sets Available
        /// </summary>
        [DataMember(Name = "available", EmitDefaultValue = false)]
        public AvailableFormats Available { get; set; }

        /// <summary>
        /// Gets or Sets Pseudo
        /// </summary>
        [DataMember(Name = "pseudo", EmitDefaultValue = true)]
        public bool Pseudo { get; set; }

        /// <summary>
        /// Gets or Sets Enrichment
        /// </summary>
        [DataMember(Name = "enrichment", EmitDefaultValue = false)]
        public SeededAssetEnrichment Enrichment { get; set; }

        /// <summary>
        /// This will let us know if this asset was generated as a &#39;demo&#39; snippet
        /// </summary>
        /// <value>This will let us know if this asset was generated as a &#39;demo&#39; snippet</value>
        [DataMember(Name = "demo", EmitDefaultValue = true)]
        public bool Demo { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class SeededAsset {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Metadata: ").Append(Metadata).Append("\n");
            sb.Append("  Application: ").Append(Application).Append("\n");
            sb.Append("  Format: ").Append(Format).Append("\n");
            sb.Append("  Discovered: ").Append(Discovered).Append("\n");
            sb.Append("  Available: ").Append(Available).Append("\n");
            sb.Append("  Pseudo: ").Append(Pseudo).Append("\n");
            sb.Append("  Enrichment: ").Append(Enrichment).Append("\n");
            sb.Append("  Demo: ").Append(Demo).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
