/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is the percursor to a fully referenced Annotation.
    /// </summary>
    [DataContract(Name = "SeededAnnotation")]
    public partial class SeededAnnotation : IValidatableObject
    {

        /// <summary>
        /// Gets or Sets Mechanism
        /// </summary>
        [DataMember(Name = "mechanism", EmitDefaultValue = false)]
        public MechanismEnum? Mechanism { get; set; }

        /// <summary>
        /// Gets or Sets Type
        /// </summary>
        [DataMember(Name = "type", IsRequired = true, EmitDefaultValue = true)]
        public AnnotationTypeEnum Type { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="SeededAnnotation" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected SeededAnnotation() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="SeededAnnotation" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="mechanism">mechanism.</param>
        /// <param name="asset">asset.</param>
        /// <param name="person">person.</param>
        /// <param name="type">type (required).</param>
        /// <param name="text">This is the text of the annotation. (required).</param>
        /// <param name="model">model.</param>
        /// <param name="pseudo">pseudo.</param>
        /// <param name="favorited">favorited.</param>
        /// <param name="anchor">anchor.</param>
        /// <param name="conversation">conversation.</param>
        /// <param name="messages">messages.</param>
        public SeededAnnotation(EmbeddedModelSchema schema = default(EmbeddedModelSchema), MechanismEnum? mechanism = default(MechanismEnum?), string asset = default(string), string person = default(string), AnnotationTypeEnum type = default(AnnotationTypeEnum), string text = default(string), string model = default(string), bool pseudo = default(bool), bool favorited = default(bool), string anchor = default(string), string conversation = default(string), FlattenedConversationMessages messages = default(FlattenedConversationMessages))
        {
            this.Type = type;
            // to ensure "text" is required (not null)
            if (text == null)
            {
                throw new ArgumentNullException("text is a required property for SeededAnnotation and cannot be null");
            }
            this.Text = text;
            this.Schema = schema;
            this.Mechanism = mechanism;
            this.Asset = asset;
            this.Person = person;
            this.Model = model;
            this.Pseudo = pseudo;
            this.Favorited = favorited;
            this.Anchor = anchor;
            this.Conversation = conversation;
            this.Messages = messages;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Asset
        /// </summary>
        [DataMember(Name = "asset", EmitDefaultValue = false)]
        public string Asset { get; set; }

        /// <summary>
        /// Gets or Sets Person
        /// </summary>
        [DataMember(Name = "person", EmitDefaultValue = false)]
        public string Person { get; set; }

        /// <summary>
        /// This is the text of the annotation.
        /// </summary>
        /// <value>This is the text of the annotation.</value>
        [DataMember(Name = "text", IsRequired = true, EmitDefaultValue = true)]
        public string Text { get; set; }

        /// <summary>
        /// Gets or Sets Model
        /// </summary>
        [DataMember(Name = "model", EmitDefaultValue = false)]
        public string Model { get; set; }

        /// <summary>
        /// Gets or Sets Pseudo
        /// </summary>
        [DataMember(Name = "pseudo", EmitDefaultValue = true)]
        public bool Pseudo { get; set; }

        /// <summary>
        /// Gets or Sets Favorited
        /// </summary>
        [DataMember(Name = "favorited", EmitDefaultValue = true)]
        public bool Favorited { get; set; }

        /// <summary>
        /// Gets or Sets Anchor
        /// </summary>
        [DataMember(Name = "anchor", EmitDefaultValue = false)]
        public string Anchor { get; set; }

        /// <summary>
        /// Gets or Sets Conversation
        /// </summary>
        [DataMember(Name = "conversation", EmitDefaultValue = false)]
        public string Conversation { get; set; }

        /// <summary>
        /// Gets or Sets Messages
        /// </summary>
        [DataMember(Name = "messages", EmitDefaultValue = false)]
        public FlattenedConversationMessages Messages { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class SeededAnnotation {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Mechanism: ").Append(Mechanism).Append("\n");
            sb.Append("  Asset: ").Append(Asset).Append("\n");
            sb.Append("  Person: ").Append(Person).Append("\n");
            sb.Append("  Type: ").Append(Type).Append("\n");
            sb.Append("  Text: ").Append(Text).Append("\n");
            sb.Append("  Model: ").Append(Model).Append("\n");
            sb.Append("  Pseudo: ").Append(Pseudo).Append("\n");
            sb.Append("  Favorited: ").Append(Favorited).Append("\n");
            sb.Append("  Anchor: ").Append(Anchor).Append("\n");
            sb.Append("  Conversation: ").Append(Conversation).Append("\n");
            sb.Append("  Messages: ").Append(Messages).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
