/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// SeededAnchorPoint
    /// </summary>
    [DataContract(Name = "SeededAnchorPoint")]
    public partial class SeededAnchorPoint : IValidatableObject
    {

        /// <summary>
        /// Gets or Sets Type
        /// </summary>
        [DataMember(Name = "type", IsRequired = true, EmitDefaultValue = true)]
        public AnchorTypeEnum Type { get; set; }

        /// <summary>
        /// Gets or Sets Platform
        /// </summary>
        [DataMember(Name = "platform", EmitDefaultValue = false)]
        public PlatformEnum? Platform { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="SeededAnchorPoint" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected SeededAnchorPoint() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="SeededAnchorPoint" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="type">type (required).</param>
        /// <param name="watch">watch.</param>
        /// <param name="fullpath">fullpath (required).</param>
        /// <param name="anchor">Cannot create an AnchorPoint w/o a Anchor. (required).</param>
        /// <param name="platform">platform.</param>
        public SeededAnchorPoint(EmbeddedModelSchema schema = default(EmbeddedModelSchema), AnchorTypeEnum type = default(AnchorTypeEnum), bool watch = default(bool), string fullpath = default(string), string anchor = default(string), PlatformEnum? platform = default(PlatformEnum?))
        {
            this.Type = type;
            // to ensure "fullpath" is required (not null)
            if (fullpath == null)
            {
                throw new ArgumentNullException("fullpath is a required property for SeededAnchorPoint and cannot be null");
            }
            this.Fullpath = fullpath;
            // to ensure "anchor" is required (not null)
            if (anchor == null)
            {
                throw new ArgumentNullException("anchor is a required property for SeededAnchorPoint and cannot be null");
            }
            this.Anchor = anchor;
            this.Schema = schema;
            this.Watch = watch;
            this.Platform = platform;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Watch
        /// </summary>
        [DataMember(Name = "watch", EmitDefaultValue = true)]
        public bool Watch { get; set; }

        /// <summary>
        /// Gets or Sets Fullpath
        /// </summary>
        [DataMember(Name = "fullpath", IsRequired = true, EmitDefaultValue = true)]
        public string Fullpath { get; set; }

        /// <summary>
        /// Cannot create an AnchorPoint w/o a Anchor.
        /// </summary>
        /// <value>Cannot create an AnchorPoint w/o a Anchor.</value>
        [DataMember(Name = "anchor", IsRequired = true, EmitDefaultValue = true)]
        public string Anchor { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class SeededAnchorPoint {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Type: ").Append(Type).Append("\n");
            sb.Append("  Watch: ").Append(Watch).Append("\n");
            sb.Append("  Fullpath: ").Append(Fullpath).Append("\n");
            sb.Append("  Anchor: ").Append(Anchor).Append("\n");
            sb.Append("  Platform: ").Append(Platform).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
