/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// SeededAnchor
    /// </summary>
    [DataContract(Name = "SeededAnchor")]
    public partial class SeededAnchor : IValidatableObject
    {

        /// <summary>
        /// Gets or Sets Type
        /// </summary>
        [DataMember(Name = "type", IsRequired = true, EmitDefaultValue = true)]
        public AnchorTypeEnum Type { get; set; }

        /// <summary>
        /// Gets or Sets Platform
        /// </summary>
        [DataMember(Name = "platform", EmitDefaultValue = false)]
        public PlatformEnum? Platform { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="SeededAnchor" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected SeededAnchor() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="SeededAnchor" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="type">type (required).</param>
        /// <param name="watch">watch.</param>
        /// <param name="fullpath">fullpath (required).</param>
        /// <param name="asset">You may associate a SeededAnchor with an asset.</param>
        /// <param name="platform">platform.</param>
        /// <param name="name">name.</param>
        /// <param name="annotations">annotations.</param>
        /// <param name="conversation">conversation.</param>
        /// <param name="persons">persons.</param>
        public SeededAnchor(EmbeddedModelSchema schema = default(EmbeddedModelSchema), AnchorTypeEnum type = default(AnchorTypeEnum), bool watch = default(bool), string fullpath = default(string), string asset = default(string), PlatformEnum? platform = default(PlatformEnum?), string name = default(string), List<SeededAnnotation> annotations = default(List<SeededAnnotation>), string conversation = default(string), FlattenedPersons persons = default(FlattenedPersons))
        {
            this.Type = type;
            // to ensure "fullpath" is required (not null)
            if (fullpath == null)
            {
                throw new ArgumentNullException("fullpath is a required property for SeededAnchor and cannot be null");
            }
            this.Fullpath = fullpath;
            this.Schema = schema;
            this.Watch = watch;
            this.Asset = asset;
            this.Platform = platform;
            this.Name = name;
            this.Annotations = annotations;
            this.Conversation = conversation;
            this.Persons = persons;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Watch
        /// </summary>
        [DataMember(Name = "watch", EmitDefaultValue = true)]
        public bool Watch { get; set; }

        /// <summary>
        /// Gets or Sets Fullpath
        /// </summary>
        [DataMember(Name = "fullpath", IsRequired = true, EmitDefaultValue = true)]
        public string Fullpath { get; set; }

        /// <summary>
        /// You may associate a SeededAnchor with an asset
        /// </summary>
        /// <value>You may associate a SeededAnchor with an asset</value>
        [DataMember(Name = "asset", EmitDefaultValue = false)]
        public string Asset { get; set; }

        /// <summary>
        /// Gets or Sets Name
        /// </summary>
        [DataMember(Name = "name", EmitDefaultValue = false)]
        public string Name { get; set; }

        /// <summary>
        /// Gets or Sets Annotations
        /// </summary>
        [DataMember(Name = "annotations", EmitDefaultValue = false)]
        public List<SeededAnnotation> Annotations { get; set; }

        /// <summary>
        /// Gets or Sets Conversation
        /// </summary>
        [DataMember(Name = "conversation", EmitDefaultValue = false)]
        public string Conversation { get; set; }

        /// <summary>
        /// Gets or Sets Persons
        /// </summary>
        [DataMember(Name = "persons", EmitDefaultValue = false)]
        public FlattenedPersons Persons { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class SeededAnchor {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Type: ").Append(Type).Append("\n");
            sb.Append("  Watch: ").Append(Watch).Append("\n");
            sb.Append("  Fullpath: ").Append(Fullpath).Append("\n");
            sb.Append("  Asset: ").Append(Asset).Append("\n");
            sb.Append("  Platform: ").Append(Platform).Append("\n");
            sb.Append("  Name: ").Append(Name).Append("\n");
            sb.Append("  Annotations: ").Append(Annotations).Append("\n");
            sb.Append("  Conversation: ").Append(Conversation).Append("\n");
            sb.Append("  Persons: ").Append(Persons).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
