/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is the preseed to a full blown Activity.  This is the minimum information needed to create an Activity, used within our [POST] /activities/create  if mechenism is not passed in we will default to AUTOMATIC  NOT required to pass in an asset/user/format.
    /// </summary>
    [DataContract(Name = "SeededActivity")]
    public partial class SeededActivity : IValidatableObject
    {

        /// <summary>
        /// Gets or Sets Mechanism
        /// </summary>
        [DataMember(Name = "mechanism", EmitDefaultValue = false)]
        public MechanismEnum? Mechanism { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="SeededActivity" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected SeededActivity() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="SeededActivity" /> class.
        /// </summary>
        /// <param name="varEvent">varEvent (required).</param>
        /// <param name="application">application (required).</param>
        /// <param name="asset">asset.</param>
        /// <param name="user">user.</param>
        /// <param name="format">format.</param>
        /// <param name="mechanism">mechanism.</param>
        /// <param name="conversation">conversation.</param>
        public SeededActivity(SeededConnectorTracking varEvent = default(SeededConnectorTracking), Application application = default(Application), ReferencedAsset asset = default(ReferencedAsset), ReferencedUser user = default(ReferencedUser), ReferencedFormat format = default(ReferencedFormat), MechanismEnum? mechanism = default(MechanismEnum?), ReferencedConversation conversation = default(ReferencedConversation))
        {
            // to ensure "varEvent" is required (not null)
            if (varEvent == null)
            {
                throw new ArgumentNullException("varEvent is a required property for SeededActivity and cannot be null");
            }
            this.Event = varEvent;
            // to ensure "application" is required (not null)
            if (application == null)
            {
                throw new ArgumentNullException("application is a required property for SeededActivity and cannot be null");
            }
            this.Application = application;
            this.Asset = asset;
            this.User = user;
            this.Format = format;
            this.Mechanism = mechanism;
            this.Conversation = conversation;
        }

        /// <summary>
        /// Gets or Sets Event
        /// </summary>
        [DataMember(Name = "event", IsRequired = true, EmitDefaultValue = true)]
        public SeededConnectorTracking Event { get; set; }

        /// <summary>
        /// Gets or Sets Application
        /// </summary>
        [DataMember(Name = "application", IsRequired = true, EmitDefaultValue = true)]
        public Application Application { get; set; }

        /// <summary>
        /// Gets or Sets Asset
        /// </summary>
        [DataMember(Name = "asset", EmitDefaultValue = false)]
        public ReferencedAsset Asset { get; set; }

        /// <summary>
        /// Gets or Sets User
        /// </summary>
        [DataMember(Name = "user", EmitDefaultValue = false)]
        public ReferencedUser User { get; set; }

        /// <summary>
        /// Gets or Sets Format
        /// </summary>
        [DataMember(Name = "format", EmitDefaultValue = false)]
        public ReferencedFormat Format { get; set; }

        /// <summary>
        /// Gets or Sets Conversation
        /// </summary>
        [DataMember(Name = "conversation", EmitDefaultValue = false)]
        public ReferencedConversation Conversation { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class SeededActivity {\n");
            sb.Append("  Event: ").Append(Event).Append("\n");
            sb.Append("  Application: ").Append(Application).Append("\n");
            sb.Append("  Asset: ").Append(Asset).Append("\n");
            sb.Append("  User: ").Append(User).Append("\n");
            sb.Append("  Format: ").Append(Format).Append("\n");
            sb.Append("  Mechanism: ").Append(Mechanism).Append("\n");
            sb.Append("  Conversation: ").Append(Conversation).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
