/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is a modle that will represent a searched asset!
    /// </summary>
    [DataContract(Name = "SearchedAsset")]
    public partial class SearchedAsset : IValidatableObject
    {

        /// <summary>
        /// Gets or Sets Match
        /// </summary>
        [DataMember(Name = "match", IsRequired = true, EmitDefaultValue = true)]
        public SearchedMatchEnum Match { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="SearchedAsset" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected SearchedAsset() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="SearchedAsset" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="asset">asset.</param>
        /// <param name="exact">exact (required).</param>
        /// <param name="score">score (required).</param>
        /// <param name="match">match (required).</param>
        /// <param name="identifier">This is the uuid of the asset. (required).</param>
        /// <param name="pseudo">If this is a pseudo asset that was also returned..</param>
        public SearchedAsset(EmbeddedModelSchema schema = default(EmbeddedModelSchema), Asset asset = default(Asset), bool exact = default(bool), decimal score = default(decimal), SearchedMatchEnum match = default(SearchedMatchEnum), string identifier = default(string), bool pseudo = default(bool))
        {
            this.Exact = exact;
            this.Score = score;
            this.Match = match;
            // to ensure "identifier" is required (not null)
            if (identifier == null)
            {
                throw new ArgumentNullException("identifier is a required property for SearchedAsset and cannot be null");
            }
            this.Identifier = identifier;
            this.Schema = schema;
            this.Asset = asset;
            this.Pseudo = pseudo;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Asset
        /// </summary>
        [DataMember(Name = "asset", EmitDefaultValue = false)]
        public Asset Asset { get; set; }

        /// <summary>
        /// Gets or Sets Exact
        /// </summary>
        [DataMember(Name = "exact", IsRequired = true, EmitDefaultValue = true)]
        public bool Exact { get; set; }

        /// <summary>
        /// Gets or Sets Score
        /// </summary>
        [DataMember(Name = "score", IsRequired = true, EmitDefaultValue = true)]
        public decimal Score { get; set; }

        /// <summary>
        /// This is the uuid of the asset.
        /// </summary>
        /// <value>This is the uuid of the asset.</value>
        [DataMember(Name = "identifier", IsRequired = true, EmitDefaultValue = true)]
        public string Identifier { get; set; }

        /// <summary>
        /// If this is a pseudo asset that was also returned.
        /// </summary>
        /// <value>If this is a pseudo asset that was also returned.</value>
        [DataMember(Name = "pseudo", EmitDefaultValue = true)]
        public bool Pseudo { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class SearchedAsset {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Asset: ").Append(Asset).Append("\n");
            sb.Append("  Exact: ").Append(Exact).Append("\n");
            sb.Append("  Score: ").Append(Score).Append("\n");
            sb.Append("  Match: ").Append(Match).Append("\n");
            sb.Append("  Identifier: ").Append(Identifier).Append("\n");
            sb.Append("  Pseudo: ").Append(Pseudo).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
