/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// A Model To Represent the Code Returned from a PKCE Response
    /// </summary>
    [DataContract(Name = "ResultedPKCE")]
    public partial class ResultedPKCE : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="ResultedPKCE" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected ResultedPKCE() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="ResultedPKCE" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="code">The PKCE Code to be used to access a Token. (required).</param>
        /// <param name="state">Likely the state that will be returned which should match the requested state as well as the nonce (required).</param>
        public ResultedPKCE(EmbeddedModelSchema schema = default(EmbeddedModelSchema), string code = default(string), string state = default(string))
        {
            // to ensure "code" is required (not null)
            if (code == null)
            {
                throw new ArgumentNullException("code is a required property for ResultedPKCE and cannot be null");
            }
            this.Code = code;
            // to ensure "state" is required (not null)
            if (state == null)
            {
                throw new ArgumentNullException("state is a required property for ResultedPKCE and cannot be null");
            }
            this.State = state;
            this.Schema = schema;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// The PKCE Code to be used to access a Token.
        /// </summary>
        /// <value>The PKCE Code to be used to access a Token.</value>
        [DataMember(Name = "code", IsRequired = true, EmitDefaultValue = true)]
        public string Code { get; set; }

        /// <summary>
        /// Likely the state that will be returned which should match the requested state as well as the nonce
        /// </summary>
        /// <value>Likely the state that will be returned which should match the requested state as well as the nonce</value>
        [DataMember(Name = "state", IsRequired = true, EmitDefaultValue = true)]
        public string State { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class ResultedPKCE {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Code: ").Append(Code).Append("\n");
            sb.Append("  State: ").Append(State).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
