/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This model is specifically for QGPT Task pipelines, the model is used to group one off tasks for instance fix/explaining/commenting that dont necessarily require a conversation form factor.
    /// </summary>
    [DataContract(Name = "QGPTTaskPipeline")]
    public partial class QGPTTaskPipeline : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="QGPTTaskPipeline" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="codeExplanation">codeExplanation.</param>
        /// <param name="codeCommentation">codeCommentation.</param>
        /// <param name="codeFix">codeFix.</param>
        /// <param name="codeModification">codeModification.</param>
        /// <param name="codeCompletion">codeCompletion.</param>
        public QGPTTaskPipeline(EmbeddedModelSchema schema = default(EmbeddedModelSchema), QGPTTaskPipelineForCodeExplanation codeExplanation = default(QGPTTaskPipelineForCodeExplanation), QGPTTaskPipelineForCodeCommentation codeCommentation = default(QGPTTaskPipelineForCodeCommentation), QGPTTaskPipelineForCodeFix codeFix = default(QGPTTaskPipelineForCodeFix), QGPTTaskPipelineForCodeModification codeModification = default(QGPTTaskPipelineForCodeModification), QGPTTaskPipelineForCodeCompletion codeCompletion = default(QGPTTaskPipelineForCodeCompletion))
        {
            this.Schema = schema;
            this.CodeExplanation = codeExplanation;
            this.CodeCommentation = codeCommentation;
            this.CodeFix = codeFix;
            this.CodeModification = codeModification;
            this.CodeCompletion = codeCompletion;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets CodeExplanation
        /// </summary>
        [DataMember(Name = "code_explanation", EmitDefaultValue = false)]
        public QGPTTaskPipelineForCodeExplanation CodeExplanation { get; set; }

        /// <summary>
        /// Gets or Sets CodeCommentation
        /// </summary>
        [DataMember(Name = "code_commentation", EmitDefaultValue = false)]
        public QGPTTaskPipelineForCodeCommentation CodeCommentation { get; set; }

        /// <summary>
        /// Gets or Sets CodeFix
        /// </summary>
        [DataMember(Name = "code_fix", EmitDefaultValue = false)]
        public QGPTTaskPipelineForCodeFix CodeFix { get; set; }

        /// <summary>
        /// Gets or Sets CodeModification
        /// </summary>
        [DataMember(Name = "code_modification", EmitDefaultValue = false)]
        public QGPTTaskPipelineForCodeModification CodeModification { get; set; }

        /// <summary>
        /// Gets or Sets CodeCompletion
        /// </summary>
        [DataMember(Name = "code_completion", EmitDefaultValue = false)]
        public QGPTTaskPipelineForCodeCompletion CodeCompletion { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class QGPTTaskPipeline {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  CodeExplanation: ").Append(CodeExplanation).Append("\n");
            sb.Append("  CodeCommentation: ").Append(CodeCommentation).Append("\n");
            sb.Append("  CodeFix: ").Append(CodeFix).Append("\n");
            sb.Append("  CodeModification: ").Append(CodeModification).Append("\n");
            sb.Append("  CodeCompletion: ").Append(CodeCompletion).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
