/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is the out for the /qgpt/stream endpoint.  200: success 401: invalid authentication/api key 429: Rate limit/Quota exceeded 500: server had an error 503: the engine is currently overloaded
    /// </summary>
    [DataContract(Name = "QGPTStreamOutput")]
    public partial class QGPTStreamOutput : IValidatableObject
    {

        /// <summary>
        /// Gets or Sets Status
        /// </summary>
        [DataMember(Name = "status", EmitDefaultValue = false)]
        public QGPTStreamEnum? Status { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="QGPTStreamOutput" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected QGPTStreamOutput() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="QGPTStreamOutput" /> class.
        /// </summary>
        /// <param name="request">This is the id used to represent the stream of response. this will always be present. We will use the value passed inby the client, or we will generate one..</param>
        /// <param name="relevance">relevance.</param>
        /// <param name="question">question.</param>
        /// <param name="status">status.</param>
        /// <param name="conversation">This is the ID of a predefined persisted conversation, if this is not present we will create a new conversation for the input/output.(in the case of a question) (required).</param>
        /// <param name="statusCode">This will be provided.</param>
        /// <param name="errorMessage">optional error message is the status code is NOT 200.</param>
        /// <param name="agentRoutes">agentRoutes.</param>
        /// <param name="extracted">extracted.</param>
        public QGPTStreamOutput(string request = default(string), QGPTRelevanceOutput relevance = default(QGPTRelevanceOutput), QGPTQuestionOutput question = default(QGPTQuestionOutput), QGPTStreamEnum? status = default(QGPTStreamEnum?), string conversation = default(string), decimal? statusCode = default(decimal?), string errorMessage = default(string), QGPTAgentRoutes agentRoutes = default(QGPTAgentRoutes), QGPTStreamedOutputExtractedMaterials extracted = default(QGPTStreamedOutputExtractedMaterials))
        {
            // to ensure "conversation" is required (not null)
            if (conversation == null)
            {
                throw new ArgumentNullException("conversation is a required property for QGPTStreamOutput and cannot be null");
            }
            this.Conversation = conversation;
            this.Request = request;
            this.Relevance = relevance;
            this.Question = question;
            this.Status = status;
            this.StatusCode = statusCode;
            this.ErrorMessage = errorMessage;
            this.AgentRoutes = agentRoutes;
            this.Extracted = extracted;
        }

        /// <summary>
        /// This is the id used to represent the stream of response. this will always be present. We will use the value passed inby the client, or we will generate one.
        /// </summary>
        /// <value>This is the id used to represent the stream of response. this will always be present. We will use the value passed inby the client, or we will generate one.</value>
        [DataMember(Name = "request", EmitDefaultValue = false)]
        public string Request { get; set; }

        /// <summary>
        /// Gets or Sets Relevance
        /// </summary>
        [DataMember(Name = "relevance", EmitDefaultValue = false)]
        public QGPTRelevanceOutput Relevance { get; set; }

        /// <summary>
        /// Gets or Sets Question
        /// </summary>
        [DataMember(Name = "question", EmitDefaultValue = false)]
        public QGPTQuestionOutput Question { get; set; }

        /// <summary>
        /// This is the ID of a predefined persisted conversation, if this is not present we will create a new conversation for the input/output.(in the case of a question)
        /// </summary>
        /// <value>This is the ID of a predefined persisted conversation, if this is not present we will create a new conversation for the input/output.(in the case of a question)</value>
        [DataMember(Name = "conversation", IsRequired = true, EmitDefaultValue = true)]
        public string Conversation { get; set; }

        /// <summary>
        /// This will be provided
        /// </summary>
        /// <value>This will be provided</value>
        [DataMember(Name = "statusCode", EmitDefaultValue = true)]
        public decimal? StatusCode { get; set; }

        /// <summary>
        /// optional error message is the status code is NOT 200
        /// </summary>
        /// <value>optional error message is the status code is NOT 200</value>
        [DataMember(Name = "errorMessage", EmitDefaultValue = false)]
        public string ErrorMessage { get; set; }

        /// <summary>
        /// Gets or Sets AgentRoutes
        /// </summary>
        [DataMember(Name = "agentRoutes", EmitDefaultValue = false)]
        public QGPTAgentRoutes AgentRoutes { get; set; }

        /// <summary>
        /// Gets or Sets Extracted
        /// </summary>
        [DataMember(Name = "extracted", EmitDefaultValue = false)]
        public QGPTStreamedOutputExtractedMaterials Extracted { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class QGPTStreamOutput {\n");
            sb.Append("  Request: ").Append(Request).Append("\n");
            sb.Append("  Relevance: ").Append(Relevance).Append("\n");
            sb.Append("  Question: ").Append(Question).Append("\n");
            sb.Append("  Status: ").Append(Status).Append("\n");
            sb.Append("  Conversation: ").Append(Conversation).Append("\n");
            sb.Append("  StatusCode: ").Append(StatusCode).Append("\n");
            sb.Append("  ErrorMessage: ").Append(ErrorMessage).Append("\n");
            sb.Append("  AgentRoutes: ").Append(AgentRoutes).Append("\n");
            sb.Append("  Extracted: ").Append(Extracted).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
