/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is the input for the /qgpt/stream endpoint.
    /// </summary>
    [DataContract(Name = "QGPTStreamInput")]
    public partial class QGPTStreamInput : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="QGPTStreamInput" /> class.
        /// </summary>
        /// <param name="relevance">relevance.</param>
        /// <param name="question">question.</param>
        /// <param name="request">This is an optional Id you can use to identify the result from your request..</param>
        /// <param name="conversation">This is the ID of a predefined persisted conversation, if this is not present we will create a new conversation for the input/output.(in the case of a question).</param>
        /// <param name="stop">This will stop the output of the current LLM.</param>
        /// <param name="reset">This will fully reset all current Activity within the QGPT stream Flows..</param>
        /// <param name="agent">This will let us know if we want to run the agent routing as well, this is default to true. However if set to false you will save on processing and you will recieve null for the agentRoutes class on the QGPTStreamOutput..</param>
        public QGPTStreamInput(QGPTRelevanceInput relevance = default(QGPTRelevanceInput), QGPTQuestionInput question = default(QGPTQuestionInput), string request = default(string), string conversation = default(string), bool stop = default(bool), bool reset = default(bool), bool agent = default(bool))
        {
            this.Relevance = relevance;
            this.Question = question;
            this.Request = request;
            this.Conversation = conversation;
            this.Stop = stop;
            this.Reset = reset;
            this.Agent = agent;
        }

        /// <summary>
        /// Gets or Sets Relevance
        /// </summary>
        [DataMember(Name = "relevance", EmitDefaultValue = false)]
        public QGPTRelevanceInput Relevance { get; set; }

        /// <summary>
        /// Gets or Sets Question
        /// </summary>
        [DataMember(Name = "question", EmitDefaultValue = false)]
        public QGPTQuestionInput Question { get; set; }

        /// <summary>
        /// This is an optional Id you can use to identify the result from your request.
        /// </summary>
        /// <value>This is an optional Id you can use to identify the result from your request.</value>
        [DataMember(Name = "request", EmitDefaultValue = false)]
        public string Request { get; set; }

        /// <summary>
        /// This is the ID of a predefined persisted conversation, if this is not present we will create a new conversation for the input/output.(in the case of a question)
        /// </summary>
        /// <value>This is the ID of a predefined persisted conversation, if this is not present we will create a new conversation for the input/output.(in the case of a question)</value>
        [DataMember(Name = "conversation", EmitDefaultValue = false)]
        public string Conversation { get; set; }

        /// <summary>
        /// This will stop the output of the current LLM
        /// </summary>
        /// <value>This will stop the output of the current LLM</value>
        [DataMember(Name = "stop", EmitDefaultValue = true)]
        public bool Stop { get; set; }

        /// <summary>
        /// This will fully reset all current Activity within the QGPT stream Flows.
        /// </summary>
        /// <value>This will fully reset all current Activity within the QGPT stream Flows.</value>
        [DataMember(Name = "reset", EmitDefaultValue = true)]
        public bool Reset { get; set; }

        /// <summary>
        /// This will let us know if we want to run the agent routing as well, this is default to true. However if set to false you will save on processing and you will recieve null for the agentRoutes class on the QGPTStreamOutput.
        /// </summary>
        /// <value>This will let us know if we want to run the agent routing as well, this is default to true. However if set to false you will save on processing and you will recieve null for the agentRoutes class on the QGPTStreamOutput.</value>
        [DataMember(Name = "agent", EmitDefaultValue = true)]
        public bool Agent { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class QGPTStreamInput {\n");
            sb.Append("  Relevance: ").Append(Relevance).Append("\n");
            sb.Append("  Question: ").Append(Question).Append("\n");
            sb.Append("  Request: ").Append(Request).Append("\n");
            sb.Append("  Conversation: ").Append(Conversation).Append("\n");
            sb.Append("  Stop: ").Append(Stop).Append("\n");
            sb.Append("  Reset: ").Append(Reset).Append("\n");
            sb.Append("  Agent: ").Append(Agent).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
