/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// Query is your followup question.  Conversation is a list of the back and fourth with the qgpt bot. where the first entry in the array was the last message sent.
    /// </summary>
    [DataContract(Name = "QGPTRepromptInput")]
    public partial class QGPTRepromptInput : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="QGPTRepromptInput" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected QGPTRepromptInput() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="QGPTRepromptInput" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="query">query (required).</param>
        /// <param name="conversation">conversation (required).</param>
        /// <param name="application">optional application id.</param>
        /// <param name="model">optional model id.</param>
        /// <param name="pipeline">pipeline.</param>
        public QGPTRepromptInput(EmbeddedModelSchema schema = default(EmbeddedModelSchema), string query = default(string), QGPTConversation conversation = default(QGPTConversation), string application = default(string), string model = default(string), QGPTPromptPipeline pipeline = default(QGPTPromptPipeline))
        {
            // to ensure "query" is required (not null)
            if (query == null)
            {
                throw new ArgumentNullException("query is a required property for QGPTRepromptInput and cannot be null");
            }
            this.Query = query;
            // to ensure "conversation" is required (not null)
            if (conversation == null)
            {
                throw new ArgumentNullException("conversation is a required property for QGPTRepromptInput and cannot be null");
            }
            this.Conversation = conversation;
            this.Schema = schema;
            this.Application = application;
            this.Model = model;
            this.Pipeline = pipeline;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Query
        /// </summary>
        [DataMember(Name = "query", IsRequired = true, EmitDefaultValue = true)]
        public string Query { get; set; }

        /// <summary>
        /// Gets or Sets Conversation
        /// </summary>
        [DataMember(Name = "conversation", IsRequired = true, EmitDefaultValue = true)]
        public QGPTConversation Conversation { get; set; }

        /// <summary>
        /// optional application id
        /// </summary>
        /// <value>optional application id</value>
        [DataMember(Name = "application", EmitDefaultValue = false)]
        public string Application { get; set; }

        /// <summary>
        /// optional model id
        /// </summary>
        /// <value>optional model id</value>
        [DataMember(Name = "model", EmitDefaultValue = false)]
        public string Model { get; set; }

        /// <summary>
        /// Gets or Sets Pipeline
        /// </summary>
        [DataMember(Name = "pipeline", EmitDefaultValue = false)]
        public QGPTPromptPipeline Pipeline { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class QGPTRepromptInput {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Query: ").Append(Query).Append("\n");
            sb.Append("  Conversation: ").Append(Conversation).Append("\n");
            sb.Append("  Application: ").Append(Application).Append("\n");
            sb.Append("  Model: ").Append(Model).Append("\n");
            sb.Append("  Pipeline: ").Append(Pipeline).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
