/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is the returned value from /code_gpt/relevance.  This will return the snippets that we found are relevant to the query you provided.  (optional) answer: in the case you provided question: true, then we will also return to you the answer to your question.  Note: - relevant: this is required property and will represent the relevant snippets, to your specific query.(NOTE: these snippet will all have respective id&#39;s and seed defined. even though id and seed are optional)
    /// </summary>
    [DataContract(Name = "QGPTRelevanceOutput")]
    public partial class QGPTRelevanceOutput : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="QGPTRelevanceOutput" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected QGPTRelevanceOutput() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="QGPTRelevanceOutput" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="answer">answer.</param>
        /// <param name="relevant">relevant (required).</param>
        public QGPTRelevanceOutput(EmbeddedModelSchema schema = default(EmbeddedModelSchema), QGPTQuestionOutput answer = default(QGPTQuestionOutput), RelevantQGPTSeeds relevant = default(RelevantQGPTSeeds))
        {
            // to ensure "relevant" is required (not null)
            if (relevant == null)
            {
                throw new ArgumentNullException("relevant is a required property for QGPTRelevanceOutput and cannot be null");
            }
            this.Relevant = relevant;
            this.Schema = schema;
            this.Answer = answer;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Answer
        /// </summary>
        [DataMember(Name = "answer", EmitDefaultValue = false)]
        public QGPTQuestionOutput Answer { get; set; }

        /// <summary>
        /// Gets or Sets Relevant
        /// </summary>
        [DataMember(Name = "relevant", IsRequired = true, EmitDefaultValue = true)]
        public RelevantQGPTSeeds Relevant { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class QGPTRelevanceOutput {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Answer: ").Append(Answer).Append("\n");
            sb.Append("  Relevant: ").Append(Relevant).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
