/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// QGPTRelevanceInputOptions
    /// </summary>
    [DataContract(Name = "QGPTRelevanceInputOptions")]
    public partial class QGPTRelevanceInputOptions : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="QGPTRelevanceInputOptions" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="database">This is an optional boolen that will tell us to use our entire snippet database as the sample..</param>
        /// <param name="question">This is an optional boolean, that will let the serve know if you want to combine the 2 endpointsboth relevance &amp;&amp; the Question endpoint to return the final results..</param>
        /// <param name="pipeline">pipeline.</param>
        public QGPTRelevanceInputOptions(EmbeddedModelSchema schema = default(EmbeddedModelSchema), bool database = default(bool), bool question = default(bool), QGPTPromptPipeline pipeline = default(QGPTPromptPipeline))
        {
            this.Schema = schema;
            this.Database = database;
            this.Question = question;
            this.Pipeline = pipeline;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// This is an optional boolen that will tell us to use our entire snippet database as the sample.
        /// </summary>
        /// <value>This is an optional boolen that will tell us to use our entire snippet database as the sample.</value>
        [DataMember(Name = "database", EmitDefaultValue = true)]
        public bool Database { get; set; }

        /// <summary>
        /// This is an optional boolean, that will let the serve know if you want to combine the 2 endpointsboth relevance &amp;&amp; the Question endpoint to return the final results.
        /// </summary>
        /// <value>This is an optional boolean, that will let the serve know if you want to combine the 2 endpointsboth relevance &amp;&amp; the Question endpoint to return the final results.</value>
        [DataMember(Name = "question", EmitDefaultValue = true)]
        public bool Question { get; set; }

        /// <summary>
        /// Gets or Sets Pipeline
        /// </summary>
        [DataMember(Name = "pipeline", EmitDefaultValue = false)]
        public QGPTPromptPipeline Pipeline { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class QGPTRelevanceInputOptions {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Database: ").Append(Database).Append("\n");
            sb.Append("  Question: ").Append(Question).Append("\n");
            sb.Append("  Pipeline: ").Append(Pipeline).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
