/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is the output/returned value from the /qgpt/question endpoint. &amp;&amp; /qgpt/followup  This will just have a single required property. the possible answers to the question, with a score.
    /// </summary>
    [DataContract(Name = "QGPTQuestionOutput")]
    public partial class QGPTQuestionOutput : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="QGPTQuestionOutput" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected QGPTQuestionOutput() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="QGPTQuestionOutput" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="answers">answers (required).</param>
        public QGPTQuestionOutput(EmbeddedModelSchema schema = default(EmbeddedModelSchema), QGPTQuestionAnswers answers = default(QGPTQuestionAnswers))
        {
            // to ensure "answers" is required (not null)
            if (answers == null)
            {
                throw new ArgumentNullException("answers is a required property for QGPTQuestionOutput and cannot be null");
            }
            this.Answers = answers;
            this.Schema = schema;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Answers
        /// </summary>
        [DataMember(Name = "answers", IsRequired = true, EmitDefaultValue = true)]
        public QGPTQuestionAnswers Answers { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class QGPTQuestionOutput {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Answers: ").Append(Answers).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
