/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is the body input for the /code_gpt/question.  Note: - each relevant seed, must require at minimum a Seed or an id used from the /code_gpt/relevance endpoint or we will throw an error.
    /// </summary>
    [DataContract(Name = "QGPTQuestionInput")]
    public partial class QGPTQuestionInput : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="QGPTQuestionInput" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected QGPTQuestionInput() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="QGPTQuestionInput" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="relevant">relevant (required).</param>
        /// <param name="query">This is the user asked question. (required).</param>
        /// <param name="application">optional application id.</param>
        /// <param name="model">optional model id.</param>
        /// <param name="messages">messages.</param>
        /// <param name="pipeline">pipeline.</param>
        /// <param name="temporal">temporal.</param>
        public QGPTQuestionInput(EmbeddedModelSchema schema = default(EmbeddedModelSchema), RelevantQGPTSeeds relevant = default(RelevantQGPTSeeds), string query = default(string), string application = default(string), string model = default(string), FlattenedConversationMessages messages = default(FlattenedConversationMessages), QGPTPromptPipeline pipeline = default(QGPTPromptPipeline), TemporalRangeGrounding temporal = default(TemporalRangeGrounding))
        {
            // to ensure "relevant" is required (not null)
            if (relevant == null)
            {
                throw new ArgumentNullException("relevant is a required property for QGPTQuestionInput and cannot be null");
            }
            this.Relevant = relevant;
            // to ensure "query" is required (not null)
            if (query == null)
            {
                throw new ArgumentNullException("query is a required property for QGPTQuestionInput and cannot be null");
            }
            this.Query = query;
            this.Schema = schema;
            this.Application = application;
            this.Model = model;
            this.Messages = messages;
            this.Pipeline = pipeline;
            this.Temporal = temporal;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Relevant
        /// </summary>
        [DataMember(Name = "relevant", IsRequired = true, EmitDefaultValue = true)]
        public RelevantQGPTSeeds Relevant { get; set; }

        /// <summary>
        /// This is the user asked question.
        /// </summary>
        /// <value>This is the user asked question.</value>
        [DataMember(Name = "query", IsRequired = true, EmitDefaultValue = true)]
        public string Query { get; set; }

        /// <summary>
        /// optional application id
        /// </summary>
        /// <value>optional application id</value>
        [DataMember(Name = "application", EmitDefaultValue = false)]
        public string Application { get; set; }

        /// <summary>
        /// optional model id
        /// </summary>
        /// <value>optional model id</value>
        [DataMember(Name = "model", EmitDefaultValue = false)]
        public string Model { get; set; }

        /// <summary>
        /// Gets or Sets Messages
        /// </summary>
        [DataMember(Name = "messages", EmitDefaultValue = false)]
        public FlattenedConversationMessages Messages { get; set; }

        /// <summary>
        /// Gets or Sets Pipeline
        /// </summary>
        [DataMember(Name = "pipeline", EmitDefaultValue = false)]
        public QGPTPromptPipeline Pipeline { get; set; }

        /// <summary>
        /// Gets or Sets Temporal
        /// </summary>
        [DataMember(Name = "temporal", EmitDefaultValue = false)]
        public TemporalRangeGrounding Temporal { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class QGPTQuestionInput {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Relevant: ").Append(Relevant).Append("\n");
            sb.Append("  Query: ").Append(Query).Append("\n");
            sb.Append("  Application: ").Append(Application).Append("\n");
            sb.Append("  Model: ").Append(Model).Append("\n");
            sb.Append("  Messages: ").Append(Messages).Append("\n");
            sb.Append("  Pipeline: ").Append(Pipeline).Append("\n");
            sb.Append("  Temporal: ").Append(Temporal).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
