/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This will take a single message, and a role.
    /// </summary>
    [DataContract(Name = "QGPTConversationMessage")]
    public partial class QGPTConversationMessage : IValidatableObject
    {

        /// <summary>
        /// Gets or Sets Role
        /// </summary>
        [DataMember(Name = "role", IsRequired = true, EmitDefaultValue = true)]
        public QGPTConversationMessageRoleEnum Role { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="QGPTConversationMessage" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected QGPTConversationMessage() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="QGPTConversationMessage" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="text">text (required).</param>
        /// <param name="role">role (required).</param>
        /// <param name="timestamp">timestamp (required).</param>
        public QGPTConversationMessage(EmbeddedModelSchema schema = default(EmbeddedModelSchema), string text = default(string), QGPTConversationMessageRoleEnum role = default(QGPTConversationMessageRoleEnum), GroupedTimestamp timestamp = default(GroupedTimestamp))
        {
            // to ensure "text" is required (not null)
            if (text == null)
            {
                throw new ArgumentNullException("text is a required property for QGPTConversationMessage and cannot be null");
            }
            this.Text = text;
            this.Role = role;
            // to ensure "timestamp" is required (not null)
            if (timestamp == null)
            {
                throw new ArgumentNullException("timestamp is a required property for QGPTConversationMessage and cannot be null");
            }
            this.Timestamp = timestamp;
            this.Schema = schema;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Text
        /// </summary>
        [DataMember(Name = "text", IsRequired = true, EmitDefaultValue = true)]
        public string Text { get; set; }

        /// <summary>
        /// Gets or Sets Timestamp
        /// </summary>
        [DataMember(Name = "timestamp", IsRequired = true, EmitDefaultValue = true)]
        public GroupedTimestamp Timestamp { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class QGPTConversationMessage {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Text: ").Append(Text).Append("\n");
            sb.Append("  Role: ").Append(Role).Append("\n");
            sb.Append("  Timestamp: ").Append(Timestamp).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
