/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is a representation of a Module or a Project  anchor: is the folder path of this repo/module  contributors: is a nice to have is all the contributors of this repo/module  range: is the amount of time this user has been working on this repo  classifications: if all the languages that are used within this repo/module
    /// </summary>
    [DataContract(Name = "ProjectModule")]
    public partial class ProjectModule : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="ProjectModule" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected ProjectModule() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="ProjectModule" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="anchor">anchor (required).</param>
        /// <param name="range">range.</param>
        /// <param name="contributors">contributors.</param>
        /// <param name="classifications">classifications.</param>
        public ProjectModule(EmbeddedModelSchema schema = default(EmbeddedModelSchema), SeededAnchor anchor = default(SeededAnchor), AnonymousTemporalRange range = default(AnonymousTemporalRange), DocumentContributors contributors = default(DocumentContributors), Classifications classifications = default(Classifications))
        {
            // to ensure "anchor" is required (not null)
            if (anchor == null)
            {
                throw new ArgumentNullException("anchor is a required property for ProjectModule and cannot be null");
            }
            this.Anchor = anchor;
            this.Schema = schema;
            this.Range = range;
            this.Contributors = contributors;
            this.Classifications = classifications;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Anchor
        /// </summary>
        [DataMember(Name = "anchor", IsRequired = true, EmitDefaultValue = true)]
        public SeededAnchor Anchor { get; set; }

        /// <summary>
        /// Gets or Sets Range
        /// </summary>
        [DataMember(Name = "range", EmitDefaultValue = false)]
        public AnonymousTemporalRange Range { get; set; }

        /// <summary>
        /// Gets or Sets Contributors
        /// </summary>
        [DataMember(Name = "contributors", EmitDefaultValue = false)]
        public DocumentContributors Contributors { get; set; }

        /// <summary>
        /// Gets or Sets Classifications
        /// </summary>
        [DataMember(Name = "classifications", EmitDefaultValue = false)]
        public Classifications Classifications { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class ProjectModule {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Anchor: ").Append(Anchor).Append("\n");
            sb.Append("  Range: ").Append(Range).Append("\n");
            sb.Append("  Contributors: ").Append(Contributors).Append("\n");
            sb.Append("  Classifications: ").Append(Classifications).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
