/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is a preview Model that will hold references to at minimum the base preview. which can be potentiall a base image, or also base text/code and then the oveylay is another format(image/text/code) that is &#39;overlayed&#39; ontop of the base format.
    /// </summary>
    [DataContract(Name = "Preview")]
    public partial class Preview : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="Preview" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected Preview() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="Preview" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="varBase">varBase (required).</param>
        /// <param name="overlay">overlay.</param>
        public Preview(EmbeddedModelSchema schema = default(EmbeddedModelSchema), ReferencedFormat varBase = default(ReferencedFormat), ReferencedFormat overlay = default(ReferencedFormat))
        {
            // to ensure "varBase" is required (not null)
            if (varBase == null)
            {
                throw new ArgumentNullException("varBase is a required property for Preview and cannot be null");
            }
            this.Base = varBase;
            this.Schema = schema;
            this.Overlay = overlay;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Base
        /// </summary>
        [DataMember(Name = "base", IsRequired = true, EmitDefaultValue = true)]
        public ReferencedFormat Base { get; set; }

        /// <summary>
        /// Gets or Sets Overlay
        /// </summary>
        [DataMember(Name = "overlay", EmitDefaultValue = false)]
        public ReferencedFormat Overlay { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class Preview {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Base: ").Append(Base).Append("\n");
            sb.Append("  Overlay: ").Append(Overlay).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
