/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is a predeleted version relating to the /external_provider/api_key/delete endpoint.  This will ensure we remove this specific provider.(anything that is set to true we will reset to null within the database.)
    /// </summary>
    [DataContract(Name = "PredeletedExternalProviderApiKey")]
    public partial class PredeletedExternalProviderApiKey : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="PredeletedExternalProviderApiKey" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected PredeletedExternalProviderApiKey() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="PredeletedExternalProviderApiKey" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="user">user (required).</param>
        /// <param name="openAI">openAI.</param>
        public PredeletedExternalProviderApiKey(EmbeddedModelSchema schema = default(EmbeddedModelSchema), string user = default(string), bool openAI = default(bool))
        {
            // to ensure "user" is required (not null)
            if (user == null)
            {
                throw new ArgumentNullException("user is a required property for PredeletedExternalProviderApiKey and cannot be null");
            }
            this.User = user;
            this.Schema = schema;
            this.OpenAI = openAI;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets User
        /// </summary>
        [DataMember(Name = "user", IsRequired = true, EmitDefaultValue = true)]
        public string User { get; set; }

        /// <summary>
        /// Gets or Sets OpenAI
        /// </summary>
        [DataMember(Name = "open_AI", EmitDefaultValue = true)]
        public bool OpenAI { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class PredeletedExternalProviderApiKey {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  User: ").Append(User).Append("\n");
            sb.Append("  OpenAI: ").Append(OpenAI).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
