/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is all optional properties around the most basic information around a non-pieces user.  A Basic type will NOT have a scope as it is not an actual pieces user.
    /// </summary>
    [DataContract(Name = "PersonBasicType")]
    public partial class PersonBasicType : IValidatableObject
    {

        /// <summary>
        /// Gets or Sets Sourced
        /// </summary>
        [DataMember(Name = "sourced", EmitDefaultValue = false)]
        public ExternallySourcedEnum? Sourced { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="PersonBasicType" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="username">username or twitter handle...etc.</param>
        /// <param name="name">This is the name of the basic user..</param>
        /// <param name="picture">this is a url picture representation of a user..</param>
        /// <param name="email">an email that was extracted..</param>
        /// <param name="sourced">sourced.</param>
        /// <param name="url">This is a specific url that this basic user came from..</param>
        /// <param name="mailgun">mailgun.</param>
        public PersonBasicType(EmbeddedModelSchema schema = default(EmbeddedModelSchema), string username = default(string), string name = default(string), string picture = default(string), string email = default(string), ExternallySourcedEnum? sourced = default(ExternallySourcedEnum?), string url = default(string), MailgunMetadata mailgun = default(MailgunMetadata))
        {
            this.Schema = schema;
            this.Username = username;
            this.Name = name;
            this.Picture = picture;
            this.Email = email;
            this.Sourced = sourced;
            this.Url = url;
            this.Mailgun = mailgun;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// username or twitter handle...etc
        /// </summary>
        /// <value>username or twitter handle...etc</value>
        [DataMember(Name = "username", EmitDefaultValue = false)]
        public string Username { get; set; }

        /// <summary>
        /// This is the name of the basic user.
        /// </summary>
        /// <value>This is the name of the basic user.</value>
        [DataMember(Name = "name", EmitDefaultValue = false)]
        public string Name { get; set; }

        /// <summary>
        /// this is a url picture representation of a user.
        /// </summary>
        /// <value>this is a url picture representation of a user.</value>
        [DataMember(Name = "picture", EmitDefaultValue = false)]
        public string Picture { get; set; }

        /// <summary>
        /// an email that was extracted.
        /// </summary>
        /// <value>an email that was extracted.</value>
        [DataMember(Name = "email", EmitDefaultValue = false)]
        public string Email { get; set; }

        /// <summary>
        /// This is a specific url that this basic user came from.
        /// </summary>
        /// <value>This is a specific url that this basic user came from.</value>
        [DataMember(Name = "url", EmitDefaultValue = false)]
        public string Url { get; set; }

        /// <summary>
        /// Gets or Sets Mailgun
        /// </summary>
        [DataMember(Name = "mailgun", EmitDefaultValue = false)]
        public MailgunMetadata Mailgun { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class PersonBasicType {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Username: ").Append(Username).Append("\n");
            sb.Append("  Name: ").Append(Name).Append("\n");
            sb.Append("  Picture: ").Append(Picture).Append("\n");
            sb.Append("  Email: ").Append(Email).Append("\n");
            sb.Append("  Sourced: ").Append(Sourced).Append("\n");
            sb.Append("  Url: ").Append(Url).Append("\n");
            sb.Append("  Mailgun: ").Append(Mailgun).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
