/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// if expiration is add then, after the alloted expiration date the user will only have view &amp;&amp; comment only permissions. Only present in the case there is a scope such as a defined collection/asset...  if asset is passed then that means this person belongs to a scoped asset.  NOTE****: annotations here are annotations to describe the person!!! if in the future we want to add who wrote an annotation on and asset or soemthing like that, we will want to add a new field on here called authorships.
    /// </summary>
    [DataContract(Name = "Person")]
    public partial class Person : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="Person" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected Person() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="Person" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="id">id (required).</param>
        /// <param name="created">created (required).</param>
        /// <param name="updated">updated (required).</param>
        /// <param name="deleted">deleted.</param>
        /// <param name="type">type (required).</param>
        /// <param name="assets">assets.</param>
        /// <param name="mechanisms">This is a Map&lt;String, MechanismEnum&gt; where the the key is an asset id..</param>
        /// <param name="interactions">This is an optional value that will keep track of the number of times this has been interacted with..</param>
        /// <param name="access">This is a Map&lt;String, PersonAccess&gt; where the the key is an asset id..</param>
        /// <param name="tags">tags.</param>
        /// <param name="websites">websites.</param>
        /// <param name="models">This is a Map&lt;String, PersonModel&gt;, where the the key is an asset id..</param>
        /// <param name="annotations">annotations.</param>
        /// <param name="score">score.</param>
        /// <param name="summaries">summaries.</param>
        /// <param name="anchors">anchors.</param>
        /// <param name="messages">messages.</param>
        public Person(EmbeddedModelSchema schema = default(EmbeddedModelSchema), string id = default(string), GroupedTimestamp created = default(GroupedTimestamp), GroupedTimestamp updated = default(GroupedTimestamp), GroupedTimestamp deleted = default(GroupedTimestamp), PersonType type = default(PersonType), FlattenedAssets assets = default(FlattenedAssets), Dictionary<string, MechanismEnum> mechanisms = default(Dictionary<string, MechanismEnum>), int interactions = default(int), Dictionary<string, PersonAccess> access = default(Dictionary<string, PersonAccess>), FlattenedTags tags = default(FlattenedTags), FlattenedWebsites websites = default(FlattenedWebsites), Dictionary<string, PersonModel> models = default(Dictionary<string, PersonModel>), FlattenedAnnotations annotations = default(FlattenedAnnotations), Score score = default(Score), FlattenedWorkstreamSummaries summaries = default(FlattenedWorkstreamSummaries), FlattenedAnchors anchors = default(FlattenedAnchors), FlattenedConversationMessages messages = default(FlattenedConversationMessages))
        {
            // to ensure "id" is required (not null)
            if (id == null)
            {
                throw new ArgumentNullException("id is a required property for Person and cannot be null");
            }
            this.Id = id;
            // to ensure "created" is required (not null)
            if (created == null)
            {
                throw new ArgumentNullException("created is a required property for Person and cannot be null");
            }
            this.Created = created;
            // to ensure "updated" is required (not null)
            if (updated == null)
            {
                throw new ArgumentNullException("updated is a required property for Person and cannot be null");
            }
            this.Updated = updated;
            // to ensure "type" is required (not null)
            if (type == null)
            {
                throw new ArgumentNullException("type is a required property for Person and cannot be null");
            }
            this.Type = type;
            this.Schema = schema;
            this.Deleted = deleted;
            this.Assets = assets;
            this.Mechanisms = mechanisms;
            this.Interactions = interactions;
            this.Access = access;
            this.Tags = tags;
            this.Websites = websites;
            this.Models = models;
            this.Annotations = annotations;
            this.Score = score;
            this.Summaries = summaries;
            this.Anchors = anchors;
            this.Messages = messages;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Id
        /// </summary>
        [DataMember(Name = "id", IsRequired = true, EmitDefaultValue = true)]
        public string Id { get; set; }

        /// <summary>
        /// Gets or Sets Created
        /// </summary>
        [DataMember(Name = "created", IsRequired = true, EmitDefaultValue = true)]
        public GroupedTimestamp Created { get; set; }

        /// <summary>
        /// Gets or Sets Updated
        /// </summary>
        [DataMember(Name = "updated", IsRequired = true, EmitDefaultValue = true)]
        public GroupedTimestamp Updated { get; set; }

        /// <summary>
        /// Gets or Sets Deleted
        /// </summary>
        [DataMember(Name = "deleted", EmitDefaultValue = false)]
        public GroupedTimestamp Deleted { get; set; }

        /// <summary>
        /// Gets or Sets Type
        /// </summary>
        [DataMember(Name = "type", IsRequired = true, EmitDefaultValue = true)]
        public PersonType Type { get; set; }

        /// <summary>
        /// Gets or Sets Assets
        /// </summary>
        [DataMember(Name = "assets", EmitDefaultValue = false)]
        public FlattenedAssets Assets { get; set; }

        /// <summary>
        /// This is a Map&lt;String, MechanismEnum&gt; where the the key is an asset id.
        /// </summary>
        /// <value>This is a Map&lt;String, MechanismEnum&gt; where the the key is an asset id.</value>
        [DataMember(Name = "mechanisms", EmitDefaultValue = false)]
        public Dictionary<string, MechanismEnum> Mechanisms { get; set; }

        /// <summary>
        /// This is an optional value that will keep track of the number of times this has been interacted with.
        /// </summary>
        /// <value>This is an optional value that will keep track of the number of times this has been interacted with.</value>
        [DataMember(Name = "interactions", EmitDefaultValue = false)]
        public int Interactions { get; set; }

        /// <summary>
        /// This is a Map&lt;String, PersonAccess&gt; where the the key is an asset id.
        /// </summary>
        /// <value>This is a Map&lt;String, PersonAccess&gt; where the the key is an asset id.</value>
        [DataMember(Name = "access", EmitDefaultValue = false)]
        public Dictionary<string, PersonAccess> Access { get; set; }

        /// <summary>
        /// Gets or Sets Tags
        /// </summary>
        [DataMember(Name = "tags", EmitDefaultValue = false)]
        public FlattenedTags Tags { get; set; }

        /// <summary>
        /// Gets or Sets Websites
        /// </summary>
        [DataMember(Name = "websites", EmitDefaultValue = false)]
        public FlattenedWebsites Websites { get; set; }

        /// <summary>
        /// This is a Map&lt;String, PersonModel&gt;, where the the key is an asset id.
        /// </summary>
        /// <value>This is a Map&lt;String, PersonModel&gt;, where the the key is an asset id.</value>
        [DataMember(Name = "models", EmitDefaultValue = false)]
        public Dictionary<string, PersonModel> Models { get; set; }

        /// <summary>
        /// Gets or Sets Annotations
        /// </summary>
        [DataMember(Name = "annotations", EmitDefaultValue = false)]
        public FlattenedAnnotations Annotations { get; set; }

        /// <summary>
        /// Gets or Sets Score
        /// </summary>
        [DataMember(Name = "score", EmitDefaultValue = false)]
        public Score Score { get; set; }

        /// <summary>
        /// Gets or Sets Summaries
        /// </summary>
        [DataMember(Name = "summaries", EmitDefaultValue = false)]
        public FlattenedWorkstreamSummaries Summaries { get; set; }

        /// <summary>
        /// Gets or Sets Anchors
        /// </summary>
        [DataMember(Name = "anchors", EmitDefaultValue = false)]
        public FlattenedAnchors Anchors { get; set; }

        /// <summary>
        /// Gets or Sets Messages
        /// </summary>
        [DataMember(Name = "messages", EmitDefaultValue = false)]
        public FlattenedConversationMessages Messages { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class Person {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Id: ").Append(Id).Append("\n");
            sb.Append("  Created: ").Append(Created).Append("\n");
            sb.Append("  Updated: ").Append(Updated).Append("\n");
            sb.Append("  Deleted: ").Append(Deleted).Append("\n");
            sb.Append("  Type: ").Append(Type).Append("\n");
            sb.Append("  Assets: ").Append(Assets).Append("\n");
            sb.Append("  Mechanisms: ").Append(Mechanisms).Append("\n");
            sb.Append("  Interactions: ").Append(Interactions).Append("\n");
            sb.Append("  Access: ").Append(Access).Append("\n");
            sb.Append("  Tags: ").Append(Tags).Append("\n");
            sb.Append("  Websites: ").Append(Websites).Append("\n");
            sb.Append("  Models: ").Append(Models).Append("\n");
            sb.Append("  Annotations: ").Append(Annotations).Append("\n");
            sb.Append("  Score: ").Append(Score).Append("\n");
            sb.Append("  Summaries: ").Append(Summaries).Append("\n");
            sb.Append("  Anchors: ").Append(Anchors).Append("\n");
            sb.Append("  Messages: ").Append(Messages).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
