/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// An object representing all of the properties involved in a PKCE Authentication Flow
    /// </summary>
    [DataContract(Name = "PKCE")]
    public partial class PKCE : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="PKCE" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="result">result.</param>
        /// <param name="challenge">challenge.</param>
        /// <param name="revocation">revocation.</param>
        /// <param name="seed">seed.</param>
        /// <param name="token">token.</param>
        /// <param name="auth0">auth0.</param>
        public PKCE(EmbeddedModelSchema schema = default(EmbeddedModelSchema), ResultedPKCE result = default(ResultedPKCE), ChallengedPKCE challenge = default(ChallengedPKCE), RevokedPKCE revocation = default(RevokedPKCE), SeededPKCE seed = default(SeededPKCE), TokenizedPKCE token = default(TokenizedPKCE), Auth0 auth0 = default(Auth0))
        {
            this.Schema = schema;
            this.Result = result;
            this.Challenge = challenge;
            this.Revocation = revocation;
            this.Seed = seed;
            this.Token = token;
            this.Auth0 = auth0;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Result
        /// </summary>
        [DataMember(Name = "result", EmitDefaultValue = false)]
        public ResultedPKCE Result { get; set; }

        /// <summary>
        /// Gets or Sets Challenge
        /// </summary>
        [DataMember(Name = "challenge", EmitDefaultValue = false)]
        public ChallengedPKCE Challenge { get; set; }

        /// <summary>
        /// Gets or Sets Revocation
        /// </summary>
        [DataMember(Name = "revocation", EmitDefaultValue = false)]
        public RevokedPKCE Revocation { get; set; }

        /// <summary>
        /// Gets or Sets Seed
        /// </summary>
        [DataMember(Name = "seed", EmitDefaultValue = false)]
        public SeededPKCE Seed { get; set; }

        /// <summary>
        /// Gets or Sets Token
        /// </summary>
        [DataMember(Name = "token", EmitDefaultValue = false)]
        public TokenizedPKCE Token { get; set; }

        /// <summary>
        /// Gets or Sets Auth0
        /// </summary>
        [DataMember(Name = "auth0", EmitDefaultValue = false)]
        public Auth0 Auth0 { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class PKCE {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Result: ").Append(Result).Append("\n");
            sb.Append("  Challenge: ").Append(Challenge).Append("\n");
            sb.Append("  Revocation: ").Append(Revocation).Append("\n");
            sb.Append("  Seed: ").Append(Seed).Append("\n");
            sb.Append("  Token: ").Append(Token).Append("\n");
            sb.Append("  Auth0: ").Append(Auth0).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
