/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is an out body for the /machine_learning/text/technical_processing/generators/personification endpoint.  This will have accepted some of the personal details (in the input body) ie languages/personas &amp;&amp; will transform this in to onbaording snippets that we will return with this model
    /// </summary>
    [DataContract(Name = "OnboardedPersonaDetails")]
    public partial class OnboardedPersonaDetails : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="OnboardedPersonaDetails" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected OnboardedPersonaDetails() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="OnboardedPersonaDetails" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="seeds">seeds (required).</param>
        public OnboardedPersonaDetails(EmbeddedModelSchema schema = default(EmbeddedModelSchema), Seeds seeds = default(Seeds))
        {
            // to ensure "seeds" is required (not null)
            if (seeds == null)
            {
                throw new ArgumentNullException("seeds is a required property for OnboardedPersonaDetails and cannot be null");
            }
            this.Seeds = seeds;
            this.Schema = schema;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Seeds
        /// </summary>
        [DataMember(Name = "seeds", IsRequired = true, EmitDefaultValue = true)]
        public Seeds Seeds { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class OnboardedPersonaDetails {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Seeds: ").Append(Seeds).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
