/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is the returnable model for the /os/device/information.
    /// </summary>
    [DataContract(Name = "OSDeviceInformationReturnable")]
    public partial class OSDeviceInformationReturnable : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="OSDeviceInformationReturnable" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="dependencies">dependencies.</param>
        /// <param name="name">this is the name of the device.</param>
        /// <param name="varVersion">this is the version of the device.</param>
        /// <param name="hardware">hardware.</param>
        public OSDeviceInformationReturnable(EmbeddedModelSchema schema = default(EmbeddedModelSchema), OSDeviceDependenciesInformation dependencies = default(OSDeviceDependenciesInformation), string name = default(string), string varVersion = default(string), OSDeviceHardwareInformation hardware = default(OSDeviceHardwareInformation))
        {
            this.Schema = schema;
            this.Dependencies = dependencies;
            this.Name = name;
            this.VarVersion = varVersion;
            this.Hardware = hardware;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Dependencies
        /// </summary>
        [DataMember(Name = "dependencies", EmitDefaultValue = false)]
        public OSDeviceDependenciesInformation Dependencies { get; set; }

        /// <summary>
        /// this is the name of the device
        /// </summary>
        /// <value>this is the name of the device</value>
        [DataMember(Name = "name", EmitDefaultValue = false)]
        public string Name { get; set; }

        /// <summary>
        /// this is the version of the device
        /// </summary>
        /// <value>this is the version of the device</value>
        [DataMember(Name = "version", EmitDefaultValue = false)]
        public string VarVersion { get; set; }

        /// <summary>
        /// Gets or Sets Hardware
        /// </summary>
        [DataMember(Name = "hardware", EmitDefaultValue = false)]
        public OSDeviceHardwareInformation Hardware { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class OSDeviceInformationReturnable {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Dependencies: ").Append(Dependencies).Append("\n");
            sb.Append("  Name: ").Append(Name).Append("\n");
            sb.Append("  VarVersion: ").Append(VarVersion).Append("\n");
            sb.Append("  Hardware: ").Append(Hardware).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
