/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This will give specific information on task specific capibilites for GPU.
    /// </summary>
    [DataContract(Name = "OSDeviceGPUHardwareCapabilitiesInformation")]
    public partial class OSDeviceGPUHardwareCapabilitiesInformation : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="OSDeviceGPUHardwareCapabilitiesInformation" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="llm">This will let us know if in the case we have a gpu and our gpu has the capabilities to use llms.</param>
        public OSDeviceGPUHardwareCapabilitiesInformation(EmbeddedModelSchema schema = default(EmbeddedModelSchema), bool llm = default(bool))
        {
            this.Schema = schema;
            this.Llm = llm;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// This will let us know if in the case we have a gpu and our gpu has the capabilities to use llms
        /// </summary>
        /// <value>This will let us know if in the case we have a gpu and our gpu has the capabilities to use llms</value>
        [DataMember(Name = "llm", EmitDefaultValue = true)]
        public bool Llm { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class OSDeviceGPUHardwareCapabilitiesInformation {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Llm: ").Append(Llm).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
