/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// A model representing a returnable response for a OAuthGroup Token
    /// </summary>
    [DataContract(Name = "OAuthToken")]
    public partial class OAuthToken : IValidatableObject
    {
        /// <summary>
        /// Defines TokenType
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public enum TokenTypeEnum
        {
            /// <summary>
            /// Enum Bearer for value: Bearer
            /// </summary>
            [EnumMember(Value = "Bearer")]
            Bearer = 1
        }


        /// <summary>
        /// Gets or Sets TokenType
        /// </summary>
        [DataMember(Name = "token_type", IsRequired = true, EmitDefaultValue = true)]
        public TokenTypeEnum TokenType { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="OAuthToken" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected OAuthToken() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="OAuthToken" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="accessToken">The Access Token (required).</param>
        /// <param name="tokenType">tokenType (required).</param>
        /// <param name="expiresIn">expiresIn (required).</param>
        /// <param name="scope">scope (required).</param>
        /// <param name="refreshToken">refreshToken.</param>
        /// <param name="idToken">idToken.</param>
        public OAuthToken(EmbeddedModelSchema schema = default(EmbeddedModelSchema), string accessToken = default(string), TokenTypeEnum tokenType = default(TokenTypeEnum), int expiresIn = default(int), string scope = default(string), string refreshToken = default(string), string idToken = default(string))
        {
            // to ensure "accessToken" is required (not null)
            if (accessToken == null)
            {
                throw new ArgumentNullException("accessToken is a required property for OAuthToken and cannot be null");
            }
            this.AccessToken = accessToken;
            this.TokenType = tokenType;
            this.ExpiresIn = expiresIn;
            // to ensure "scope" is required (not null)
            if (scope == null)
            {
                throw new ArgumentNullException("scope is a required property for OAuthToken and cannot be null");
            }
            this.Scope = scope;
            this.Schema = schema;
            this.RefreshToken = refreshToken;
            this.IdToken = idToken;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// The Access Token
        /// </summary>
        /// <value>The Access Token</value>
        [DataMember(Name = "access_token", IsRequired = true, EmitDefaultValue = true)]
        public string AccessToken { get; set; }

        /// <summary>
        /// Gets or Sets ExpiresIn
        /// </summary>
        /*
        <example>86400</example>
        */
        [DataMember(Name = "expires_in", IsRequired = true, EmitDefaultValue = true)]
        public int ExpiresIn { get; set; }

        /// <summary>
        /// Gets or Sets Scope
        /// </summary>
        [DataMember(Name = "scope", IsRequired = true, EmitDefaultValue = true)]
        public string Scope { get; set; }

        /// <summary>
        /// Gets or Sets RefreshToken
        /// </summary>
        [DataMember(Name = "refresh_token", EmitDefaultValue = false)]
        public string RefreshToken { get; set; }

        /// <summary>
        /// Gets or Sets IdToken
        /// </summary>
        [DataMember(Name = "id_token", EmitDefaultValue = false)]
        public string IdToken { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class OAuthToken {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  AccessToken: ").Append(AccessToken).Append("\n");
            sb.Append("  TokenType: ").Append(TokenType).Append("\n");
            sb.Append("  ExpiresIn: ").Append(ExpiresIn).Append("\n");
            sb.Append("  Scope: ").Append(Scope).Append("\n");
            sb.Append("  RefreshToken: ").Append(RefreshToken).Append("\n");
            sb.Append("  IdToken: ").Append(IdToken).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
