/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// A Model to support account creation to Auth0&#39;s Database.
    /// </summary>
    [DataContract(Name = "OAuthAccount")]
    public partial class OAuthAccount : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="OAuthAccount" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected OAuthAccount() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="OAuthAccount" /> class.
        /// </summary>
        /// <param name="clientId">The client_id of your client. (required).</param>
        /// <param name="email">The user&#39;s email address. (required).</param>
        /// <param name="connection">The name of the database configured to your client. (required).</param>
        /// <param name="username">The user&#39;s username. Only valid if the connection requires a username. (required).</param>
        /// <param name="givenName">The user&#39;s given name(s). (required).</param>
        /// <param name="familyName">The user&#39;s family name(s). (required).</param>
        /// <param name="name">The user&#39;s full name. (required).</param>
        /// <param name="picture">A URI pointing to the user&#39;s picture. (required).</param>
        /// <param name="nickname">The user&#39;s nickname. (required).</param>
        public OAuthAccount(string clientId = default(string), string email = default(string), string connection = default(string), string username = default(string), string givenName = default(string), string familyName = default(string), string name = default(string), string picture = default(string), string nickname = default(string))
        {
            // to ensure "clientId" is required (not null)
            if (clientId == null)
            {
                throw new ArgumentNullException("clientId is a required property for OAuthAccount and cannot be null");
            }
            this.ClientId = clientId;
            // to ensure "email" is required (not null)
            if (email == null)
            {
                throw new ArgumentNullException("email is a required property for OAuthAccount and cannot be null");
            }
            this.Email = email;
            // to ensure "connection" is required (not null)
            if (connection == null)
            {
                throw new ArgumentNullException("connection is a required property for OAuthAccount and cannot be null");
            }
            this.Connection = connection;
            // to ensure "username" is required (not null)
            if (username == null)
            {
                throw new ArgumentNullException("username is a required property for OAuthAccount and cannot be null");
            }
            this.Username = username;
            // to ensure "givenName" is required (not null)
            if (givenName == null)
            {
                throw new ArgumentNullException("givenName is a required property for OAuthAccount and cannot be null");
            }
            this.GivenName = givenName;
            // to ensure "familyName" is required (not null)
            if (familyName == null)
            {
                throw new ArgumentNullException("familyName is a required property for OAuthAccount and cannot be null");
            }
            this.FamilyName = familyName;
            // to ensure "name" is required (not null)
            if (name == null)
            {
                throw new ArgumentNullException("name is a required property for OAuthAccount and cannot be null");
            }
            this.Name = name;
            // to ensure "picture" is required (not null)
            if (picture == null)
            {
                throw new ArgumentNullException("picture is a required property for OAuthAccount and cannot be null");
            }
            this.Picture = picture;
            // to ensure "nickname" is required (not null)
            if (nickname == null)
            {
                throw new ArgumentNullException("nickname is a required property for OAuthAccount and cannot be null");
            }
            this.Nickname = nickname;
        }

        /// <summary>
        /// The client_id of your client.
        /// </summary>
        /// <value>The client_id of your client.</value>
        [DataMember(Name = "client_id", IsRequired = true, EmitDefaultValue = true)]
        public string ClientId { get; set; }

        /// <summary>
        /// The user&#39;s email address.
        /// </summary>
        /// <value>The user&#39;s email address.</value>
        [DataMember(Name = "email", IsRequired = true, EmitDefaultValue = true)]
        public string Email { get; set; }

        /// <summary>
        /// The name of the database configured to your client.
        /// </summary>
        /// <value>The name of the database configured to your client.</value>
        [DataMember(Name = "connection", IsRequired = true, EmitDefaultValue = true)]
        public string Connection { get; set; }

        /// <summary>
        /// The user&#39;s username. Only valid if the connection requires a username.
        /// </summary>
        /// <value>The user&#39;s username. Only valid if the connection requires a username.</value>
        [DataMember(Name = "username", IsRequired = true, EmitDefaultValue = true)]
        public string Username { get; set; }

        /// <summary>
        /// The user&#39;s given name(s).
        /// </summary>
        /// <value>The user&#39;s given name(s).</value>
        [DataMember(Name = "given_name", IsRequired = true, EmitDefaultValue = true)]
        public string GivenName { get; set; }

        /// <summary>
        /// The user&#39;s family name(s).
        /// </summary>
        /// <value>The user&#39;s family name(s).</value>
        [DataMember(Name = "family_name", IsRequired = true, EmitDefaultValue = true)]
        public string FamilyName { get; set; }

        /// <summary>
        /// The user&#39;s full name.
        /// </summary>
        /// <value>The user&#39;s full name.</value>
        [DataMember(Name = "name", IsRequired = true, EmitDefaultValue = true)]
        public string Name { get; set; }

        /// <summary>
        /// A URI pointing to the user&#39;s picture.
        /// </summary>
        /// <value>A URI pointing to the user&#39;s picture.</value>
        [DataMember(Name = "picture", IsRequired = true, EmitDefaultValue = true)]
        public string Picture { get; set; }

        /// <summary>
        /// The user&#39;s nickname.
        /// </summary>
        /// <value>The user&#39;s nickname.</value>
        [DataMember(Name = "nickname", IsRequired = true, EmitDefaultValue = true)]
        public string Nickname { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class OAuthAccount {\n");
            sb.Append("  ClientId: ").Append(ClientId).Append("\n");
            sb.Append("  Email: ").Append(Email).Append("\n");
            sb.Append("  Connection: ").Append(Connection).Append("\n");
            sb.Append("  Username: ").Append(Username).Append("\n");
            sb.Append("  GivenName: ").Append(GivenName).Append("\n");
            sb.Append("  FamilyName: ").Append(FamilyName).Append("\n");
            sb.Append("  Name: ").Append(Name).Append("\n");
            sb.Append("  Picture: ").Append(Picture).Append("\n");
            sb.Append("  Nickname: ").Append(Nickname).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
                        // ClientId (string) minLength
                        if (this.ClientId != null && this.ClientId.Length < 1)
                        {
                        yield return new System.ComponentModel.DataAnnotations.ValidationResult("Invalid value for ClientId, length must be greater than or equal to 1.", new [] { "ClientId" });
                        }
                        // Email (string) minLength
                        if (this.Email != null && this.Email.Length < 1)
                        {
                        yield return new System.ComponentModel.DataAnnotations.ValidationResult("Invalid value for Email, length must be greater than or equal to 1.", new [] { "Email" });
                        }
                        // Connection (string) minLength
                        if (this.Connection != null && this.Connection.Length < 1)
                        {
                        yield return new System.ComponentModel.DataAnnotations.ValidationResult("Invalid value for Connection, length must be greater than or equal to 1.", new [] { "Connection" });
                        }
                        // Username (string) minLength
                        if (this.Username != null && this.Username.Length < 1)
                        {
                        yield return new System.ComponentModel.DataAnnotations.ValidationResult("Invalid value for Username, length must be greater than or equal to 1.", new [] { "Username" });
                        }
                        // GivenName (string) minLength
                        if (this.GivenName != null && this.GivenName.Length < 1)
                        {
                        yield return new System.ComponentModel.DataAnnotations.ValidationResult("Invalid value for GivenName, length must be greater than or equal to 1.", new [] { "GivenName" });
                        }
                        // FamilyName (string) minLength
                        if (this.FamilyName != null && this.FamilyName.Length < 1)
                        {
                        yield return new System.ComponentModel.DataAnnotations.ValidationResult("Invalid value for FamilyName, length must be greater than or equal to 1.", new [] { "FamilyName" });
                        }
                        // Name (string) minLength
                        if (this.Name != null && this.Name.Length < 1)
                        {
                        yield return new System.ComponentModel.DataAnnotations.ValidationResult("Invalid value for Name, length must be greater than or equal to 1.", new [] { "Name" });
                        }
                        // Picture (string) minLength
                        if (this.Picture != null && this.Picture.Length < 1)
                        {
                        yield return new System.ComponentModel.DataAnnotations.ValidationResult("Invalid value for Picture, length must be greater than or equal to 1.", new [] { "Picture" });
                        }
                        // Nickname (string) minLength
                        if (this.Nickname != null && this.Nickname.Length < 1)
                        {
                        yield return new System.ComponentModel.DataAnnotations.ValidationResult("Invalid value for Nickname, length must be greater than or equal to 1.", new [] { "Nickname" });
                        }
            yield break;
        }
    }

}
