/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is the model that is sent over our ws for streaming the progress of a model that is being downloaded.  can eventually add a number that display the percent downloaded an so on.(this is called percent 0-100)
    /// </summary>
    [DataContract(Name = "ModelDownloadProgress")]
    public partial class ModelDownloadProgress : IValidatableObject
    {

        /// <summary>
        /// Gets or Sets Status
        /// </summary>
        [DataMember(Name = "status", EmitDefaultValue = false)]
        public ModelDownloadProgressStatusEnum? Status { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="ModelDownloadProgress" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="status">status.</param>
        /// <param name="percentage">Optionally if the download is in progress you will recieve a download percent(from 0-100)..</param>
        public ModelDownloadProgress(EmbeddedModelSchema schema = default(EmbeddedModelSchema), ModelDownloadProgressStatusEnum? status = default(ModelDownloadProgressStatusEnum?), decimal? percentage = default(decimal?))
        {
            this.Schema = schema;
            this.Status = status;
            this.Percentage = percentage;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Optionally if the download is in progress you will recieve a download percent(from 0-100).
        /// </summary>
        /// <value>Optionally if the download is in progress you will recieve a download percent(from 0-100).</value>
        [DataMember(Name = "percentage", EmitDefaultValue = true)]
        public decimal? Percentage { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class ModelDownloadProgress {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Status: ").Append(Status).Append("\n");
            sb.Append("  Percentage: ").Append(Percentage).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
