/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This will let us know what capabilities the model is aloud to be used for.
    /// </summary>
    [DataContract(Name = "ModelCapabilities")]
    public partial class ModelCapabilities : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="ModelCapabilities" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="temporal">True if model is able to support live context and any other temporally powered RAG Capabilities i.e. \&quot;What did I do yesterday?\&quot;.</param>
        /// <param name="images">True if the model can leverage images and graphical material files in it&#39;s context window.</param>
        /// <param name="videos">True if the model can leverage videos files in it&#39;s context window.</param>
        /// <param name="documents">True if the model can leverage code/text/other files in it&#39;s context window.</param>
        /// <param name="codebases">True if the model can leverage entire code bases/snippetized code bases in its context window.</param>
        /// <param name="assets">True if the model can leverage saved assets &amp; their metadata in its context window..</param>
        /// <param name="websites">True if the model can leverage websites in its context window..</param>
        public ModelCapabilities(EmbeddedModelSchema schema = default(EmbeddedModelSchema), bool temporal = default(bool), bool images = default(bool), bool videos = default(bool), bool documents = default(bool), bool codebases = default(bool), bool assets = default(bool), bool websites = default(bool))
        {
            this.Schema = schema;
            this.Temporal = temporal;
            this.Images = images;
            this.Videos = videos;
            this.Documents = documents;
            this.Codebases = codebases;
            this.Assets = assets;
            this.Websites = websites;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// True if model is able to support Pieces Long-Term Memory and any other temporally powered RAG Capabilities i.e. \&quot;What did I do yesterday?\&quot;
        /// </summary>
        /// <value>True if model is able to support Pieces Long-Term Memory and any other temporally powered RAG Capabilities i.e. \&quot;What did I do yesterday?\&quot;</value>
        [DataMember(Name = "temporal", EmitDefaultValue = true)]
        public bool Temporal { get; set; }

        /// <summary>
        /// True if the model can leverage images and graphical material files in it&#39;s context window
        /// </summary>
        /// <value>True if the model can leverage images and graphical material files in it&#39;s context window</value>
        [DataMember(Name = "images", EmitDefaultValue = true)]
        public bool Images { get; set; }

        /// <summary>
        /// True if the model can leverage videos files in it&#39;s context window
        /// </summary>
        /// <value>True if the model can leverage videos files in it&#39;s context window</value>
        [DataMember(Name = "videos", EmitDefaultValue = true)]
        public bool Videos { get; set; }

        /// <summary>
        /// True if the model can leverage code/text/other files in it&#39;s context window
        /// </summary>
        /// <value>True if the model can leverage code/text/other files in it&#39;s context window</value>
        [DataMember(Name = "documents", EmitDefaultValue = true)]
        public bool Documents { get; set; }

        /// <summary>
        /// True if the model can leverage entire code bases/snippetized code bases in its context window
        /// </summary>
        /// <value>True if the model can leverage entire code bases/snippetized code bases in its context window</value>
        [DataMember(Name = "codebases", EmitDefaultValue = true)]
        public bool Codebases { get; set; }

        /// <summary>
        /// True if the model can leverage saved assets &amp; their metadata in its context window.
        /// </summary>
        /// <value>True if the model can leverage saved assets &amp; their metadata in its context window.</value>
        [DataMember(Name = "assets", EmitDefaultValue = true)]
        public bool Assets { get; set; }

        /// <summary>
        /// True if the model can leverage websites in its context window.
        /// </summary>
        /// <value>True if the model can leverage websites in its context window.</value>
        [DataMember(Name = "websites", EmitDefaultValue = true)]
        public bool Websites { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class ModelCapabilities {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Temporal: ").Append(Temporal).Append("\n");
            sb.Append("  Images: ").Append(Images).Append("\n");
            sb.Append("  Videos: ").Append(Videos).Append("\n");
            sb.Append("  Documents: ").Append(Documents).Append("\n");
            sb.Append("  Codebases: ").Append(Codebases).Append("\n");
            sb.Append("  Assets: ").Append(Assets).Append("\n");
            sb.Append("  Websites: ").Append(Websites).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
