/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is a Machine Learning Model, that will give readable information about the Machine Learning Model Used.
    /// </summary>
    [DataContract(Name = "Model")]
    public partial class Model : IValidatableObject
    {

        /// <summary>
        /// Gets or Sets Type
        /// </summary>
        [DataMember(Name = "type", IsRequired = true, EmitDefaultValue = true)]
        public ModelTypeEnum Type { get; set; }

        /// <summary>
        /// Gets or Sets Usage
        /// </summary>
        [DataMember(Name = "usage", IsRequired = true, EmitDefaultValue = true)]
        public ModelUsageEnum Usage { get; set; }

        /// <summary>
        /// Gets or Sets Foundation
        /// </summary>
        [DataMember(Name = "foundation", EmitDefaultValue = false)]
        public ModelFoundationEnum? Foundation { get; set; }

        /// <summary>
        /// Gets or Sets Provider
        /// </summary>
        [DataMember(Name = "provider", EmitDefaultValue = false)]
        public ExternalMLProviderEnum? Provider { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="Model" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected Model() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="Model" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="id">uuid  (required).</param>
        /// <param name="varVersion">this is a version of the model. (required).</param>
        /// <param name="created">created (required).</param>
        /// <param name="name">This is an Optional Name of the Model. (required).</param>
        /// <param name="description">An Optional Description of the model itself..</param>
        /// <param name="cloud">This will inform the user if this was a model that is hosted in the cloud (required).</param>
        /// <param name="type">type (required).</param>
        /// <param name="usage">usage (required).</param>
        /// <param name="bytes">bytes.</param>
        /// <param name="ram">ram.</param>
        /// <param name="quantization">quantization is a string like: q8f16_0,  q4f16_1, etc....</param>
        /// <param name="foundation">foundation.</param>
        /// <param name="downloaded">This is an optional bool to let us know if this model has been downloaded locally..</param>
        /// <param name="loaded">This is a boolean that represents if the model is loaded into memory.(this is not persisted, and is calculated on the fly.).</param>
        /// <param name="unique">This is the unique model name used to load the model..</param>
        /// <param name="parameters">This is the number of parameters in terms of billions..</param>
        /// <param name="provider">provider.</param>
        /// <param name="cpu">This is an optional bool that is optimized for CPU usage..</param>
        /// <param name="downloading">This is a calculated property, that will say if this is currently downloading..</param>
        /// <param name="maxTokens">maxTokens.</param>
        /// <param name="custom">This will let us know if this is a custom, or fine tuned model imported by the user..</param>
        /// <param name="capabilities">capabilities.</param>
        public Model(EmbeddedModelSchema schema = default(EmbeddedModelSchema), string id = default(string), string varVersion = default(string), GroupedTimestamp created = default(GroupedTimestamp), string name = default(string), string description = default(string), bool cloud = default(bool), ModelTypeEnum type = default(ModelTypeEnum), ModelUsageEnum usage = default(ModelUsageEnum), ByteDescriptor bytes = default(ByteDescriptor), ByteDescriptor ram = default(ByteDescriptor), string quantization = default(string), ModelFoundationEnum? foundation = default(ModelFoundationEnum?), bool downloaded = default(bool), bool loaded = default(bool), string unique = default(string), decimal? parameters = default(decimal?), ExternalMLProviderEnum? provider = default(ExternalMLProviderEnum?), bool cpu = default(bool), bool downloading = default(bool), ModelMaxTokens maxTokens = default(ModelMaxTokens), bool custom = default(bool), ModelCapabilities capabilities = default(ModelCapabilities))
        {
            // to ensure "id" is required (not null)
            if (id == null)
            {
                throw new ArgumentNullException("id is a required property for Model and cannot be null");
            }
            this.Id = id;
            // to ensure "varVersion" is required (not null)
            if (varVersion == null)
            {
                throw new ArgumentNullException("varVersion is a required property for Model and cannot be null");
            }
            this.VarVersion = varVersion;
            // to ensure "created" is required (not null)
            if (created == null)
            {
                throw new ArgumentNullException("created is a required property for Model and cannot be null");
            }
            this.Created = created;
            // to ensure "name" is required (not null)
            if (name == null)
            {
                throw new ArgumentNullException("name is a required property for Model and cannot be null");
            }
            this.Name = name;
            this.Cloud = cloud;
            this.Type = type;
            this.Usage = usage;
            this.Schema = schema;
            this.Description = description;
            this.Bytes = bytes;
            this.Ram = ram;
            this.Quantization = quantization;
            this.Foundation = foundation;
            this.Downloaded = downloaded;
            this.Loaded = loaded;
            this.Unique = unique;
            this.Parameters = parameters;
            this.Provider = provider;
            this.Cpu = cpu;
            this.Downloading = downloading;
            this.MaxTokens = maxTokens;
            this.Custom = custom;
            this.Capabilities = capabilities;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// uuid 
        /// </summary>
        /// <value>uuid </value>
        [DataMember(Name = "id", IsRequired = true, EmitDefaultValue = true)]
        public string Id { get; set; }

        /// <summary>
        /// this is a version of the model.
        /// </summary>
        /// <value>this is a version of the model.</value>
        [DataMember(Name = "version", IsRequired = true, EmitDefaultValue = true)]
        public string VarVersion { get; set; }

        /// <summary>
        /// Gets or Sets Created
        /// </summary>
        [DataMember(Name = "created", IsRequired = true, EmitDefaultValue = true)]
        public GroupedTimestamp Created { get; set; }

        /// <summary>
        /// This is an Optional Name of the Model.
        /// </summary>
        /// <value>This is an Optional Name of the Model.</value>
        [DataMember(Name = "name", IsRequired = true, EmitDefaultValue = true)]
        public string Name { get; set; }

        /// <summary>
        /// An Optional Description of the model itself.
        /// </summary>
        /// <value>An Optional Description of the model itself.</value>
        [DataMember(Name = "description", EmitDefaultValue = false)]
        public string Description { get; set; }

        /// <summary>
        /// This will inform the user if this was a model that is hosted in the cloud
        /// </summary>
        /// <value>This will inform the user if this was a model that is hosted in the cloud</value>
        [DataMember(Name = "cloud", IsRequired = true, EmitDefaultValue = true)]
        public bool Cloud { get; set; }

        /// <summary>
        /// Gets or Sets Bytes
        /// </summary>
        [DataMember(Name = "bytes", EmitDefaultValue = false)]
        public ByteDescriptor Bytes { get; set; }

        /// <summary>
        /// Gets or Sets Ram
        /// </summary>
        [DataMember(Name = "ram", EmitDefaultValue = false)]
        public ByteDescriptor Ram { get; set; }

        /// <summary>
        /// quantization is a string like: q8f16_0,  q4f16_1, etc...
        /// </summary>
        /// <value>quantization is a string like: q8f16_0,  q4f16_1, etc...</value>
        [DataMember(Name = "quantization", EmitDefaultValue = false)]
        public string Quantization { get; set; }

        /// <summary>
        /// This is an optional bool to let us know if this model has been downloaded locally.
        /// </summary>
        /// <value>This is an optional bool to let us know if this model has been downloaded locally.</value>
        [DataMember(Name = "downloaded", EmitDefaultValue = true)]
        public bool Downloaded { get; set; }

        /// <summary>
        /// This is a boolean that represents if the model is loaded into memory.(this is not persisted, and is calculated on the fly.)
        /// </summary>
        /// <value>This is a boolean that represents if the model is loaded into memory.(this is not persisted, and is calculated on the fly.)</value>
        [DataMember(Name = "loaded", EmitDefaultValue = true)]
        public bool Loaded { get; set; }

        /// <summary>
        /// This is the unique model name used to load the model.
        /// </summary>
        /// <value>This is the unique model name used to load the model.</value>
        [DataMember(Name = "unique", EmitDefaultValue = false)]
        public string Unique { get; set; }

        /// <summary>
        /// This is the number of parameters in terms of billions.
        /// </summary>
        /// <value>This is the number of parameters in terms of billions.</value>
        [DataMember(Name = "parameters", EmitDefaultValue = true)]
        public decimal? Parameters { get; set; }

        /// <summary>
        /// This is an optional bool that is optimized for CPU usage.
        /// </summary>
        /// <value>This is an optional bool that is optimized for CPU usage.</value>
        [DataMember(Name = "cpu", EmitDefaultValue = true)]
        public bool Cpu { get; set; }

        /// <summary>
        /// This is a calculated property, that will say if this is currently downloading.
        /// </summary>
        /// <value>This is a calculated property, that will say if this is currently downloading.</value>
        [DataMember(Name = "downloading", EmitDefaultValue = true)]
        public bool Downloading { get; set; }

        /// <summary>
        /// Gets or Sets MaxTokens
        /// </summary>
        [DataMember(Name = "maxTokens", EmitDefaultValue = false)]
        public ModelMaxTokens MaxTokens { get; set; }

        /// <summary>
        /// This will let us know if this is a custom, or fine tuned model imported by the user.
        /// </summary>
        /// <value>This will let us know if this is a custom, or fine tuned model imported by the user.</value>
        [DataMember(Name = "custom", EmitDefaultValue = true)]
        public bool Custom { get; set; }

        /// <summary>
        /// Gets or Sets Capabilities
        /// </summary>
        [DataMember(Name = "capabilities", EmitDefaultValue = false)]
        public ModelCapabilities Capabilities { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class Model {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Id: ").Append(Id).Append("\n");
            sb.Append("  VarVersion: ").Append(VarVersion).Append("\n");
            sb.Append("  Created: ").Append(Created).Append("\n");
            sb.Append("  Name: ").Append(Name).Append("\n");
            sb.Append("  Description: ").Append(Description).Append("\n");
            sb.Append("  Cloud: ").Append(Cloud).Append("\n");
            sb.Append("  Type: ").Append(Type).Append("\n");
            sb.Append("  Usage: ").Append(Usage).Append("\n");
            sb.Append("  Bytes: ").Append(Bytes).Append("\n");
            sb.Append("  Ram: ").Append(Ram).Append("\n");
            sb.Append("  Quantization: ").Append(Quantization).Append("\n");
            sb.Append("  Foundation: ").Append(Foundation).Append("\n");
            sb.Append("  Downloaded: ").Append(Downloaded).Append("\n");
            sb.Append("  Loaded: ").Append(Loaded).Append("\n");
            sb.Append("  Unique: ").Append(Unique).Append("\n");
            sb.Append("  Parameters: ").Append(Parameters).Append("\n");
            sb.Append("  Provider: ").Append(Provider).Append("\n");
            sb.Append("  Cpu: ").Append(Cpu).Append("\n");
            sb.Append("  Downloading: ").Append(Downloading).Append("\n");
            sb.Append("  MaxTokens: ").Append(MaxTokens).Append("\n");
            sb.Append("  Custom: ").Append(Custom).Append("\n");
            sb.Append("  Capabilities: ").Append(Capabilities).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
