/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// This is the incoming linkify model.  if access is PRIVATE then please provide and array of users to enable the link for. 
    /// </summary>
    [DataContract(Name = "Linkify")]
    public partial class Linkify : IValidatableObject
    {

        /// <summary>
        /// Gets or Sets Access
        /// </summary>
        [DataMember(Name = "access", IsRequired = true, EmitDefaultValue = true)]
        public AccessEnum Access { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="Linkify" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected Linkify() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="Linkify" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="seed">seed.</param>
        /// <param name="asset">asset.</param>
        /// <param name="users">this is an array of users..</param>
        /// <param name="access">access (required).</param>
        /// <param name="distributions">distributions.</param>
        public Linkify(EmbeddedModelSchema schema = default(EmbeddedModelSchema), Seed seed = default(Seed), Asset asset = default(Asset), List<SeededUser> users = default(List<SeededUser>), AccessEnum access = default(AccessEnum), SeededDistributions distributions = default(SeededDistributions))
        {
            this.Access = access;
            this.Schema = schema;
            this.Seed = seed;
            this.Asset = asset;
            this.Users = users;
            this.Distributions = distributions;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Seed
        /// </summary>
        [DataMember(Name = "seed", EmitDefaultValue = false)]
        public Seed Seed { get; set; }

        /// <summary>
        /// Gets or Sets Asset
        /// </summary>
        [DataMember(Name = "asset", EmitDefaultValue = false)]
        public Asset Asset { get; set; }

        /// <summary>
        /// this is an array of users.
        /// </summary>
        /// <value>this is an array of users.</value>
        [DataMember(Name = "users", EmitDefaultValue = false)]
        public List<SeededUser> Users { get; set; }

        /// <summary>
        /// Gets or Sets Distributions
        /// </summary>
        [DataMember(Name = "distributions", EmitDefaultValue = false)]
        public SeededDistributions Distributions { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class Linkify {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Seed: ").Append(Seed).Append("\n");
            sb.Append("  Asset: ").Append(Asset).Append("\n");
            sb.Append("  Users: ").Append(Users).Append("\n");
            sb.Append("  Access: ").Append(Access).Append("\n");
            sb.Append("  Distributions: ").Append(Distributions).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
