/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// modeled after this (https://microsoft.github.io/language-server-protocol/specifications/lsp/3.17/specification/#range)
    /// </summary>
    [DataContract(Name = "LanguageServerProtocolLocationRange")]
    public partial class LanguageServerProtocolLocationRange : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="LanguageServerProtocolLocationRange" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected LanguageServerProtocolLocationRange() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="LanguageServerProtocolLocationRange" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="start">start (required).</param>
        /// <param name="end">end (required).</param>
        public LanguageServerProtocolLocationRange(EmbeddedModelSchema schema = default(EmbeddedModelSchema), LanguageServerProtocolLocationRangePosition start = default(LanguageServerProtocolLocationRangePosition), LanguageServerProtocolLocationRangePosition end = default(LanguageServerProtocolLocationRangePosition))
        {
            // to ensure "start" is required (not null)
            if (start == null)
            {
                throw new ArgumentNullException("start is a required property for LanguageServerProtocolLocationRange and cannot be null");
            }
            this.Start = start;
            // to ensure "end" is required (not null)
            if (end == null)
            {
                throw new ArgumentNullException("end is a required property for LanguageServerProtocolLocationRange and cannot be null");
            }
            this.End = end;
            this.Schema = schema;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Start
        /// </summary>
        [DataMember(Name = "start", IsRequired = true, EmitDefaultValue = true)]
        public LanguageServerProtocolLocationRangePosition Start { get; set; }

        /// <summary>
        /// Gets or Sets End
        /// </summary>
        [DataMember(Name = "end", IsRequired = true, EmitDefaultValue = true)]
        public LanguageServerProtocolLocationRangePosition End { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class LanguageServerProtocolLocationRange {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Start: ").Append(Start).Append("\n");
            sb.Append("  End: ").Append(End).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
