/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// modeled after this (https://microsoft.github.io/language-server-protocol/specifications/lsp/3.17/specification/#location)  uri: is jsut a file path  range: here is the location of where this item is within the file.
    /// </summary>
    [DataContract(Name = "LanguageServerProtocolLocation")]
    public partial class LanguageServerProtocolLocation : IValidatableObject
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="LanguageServerProtocolLocation" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected LanguageServerProtocolLocation() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="LanguageServerProtocolLocation" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="uri">uri (required).</param>
        /// <param name="range">range (required).</param>
        public LanguageServerProtocolLocation(EmbeddedModelSchema schema = default(EmbeddedModelSchema), string uri = default(string), LanguageServerProtocolLocationRange range = default(LanguageServerProtocolLocationRange))
        {
            // to ensure "uri" is required (not null)
            if (uri == null)
            {
                throw new ArgumentNullException("uri is a required property for LanguageServerProtocolLocation and cannot be null");
            }
            this.Uri = uri;
            // to ensure "range" is required (not null)
            if (range == null)
            {
                throw new ArgumentNullException("range is a required property for LanguageServerProtocolLocation and cannot be null");
            }
            this.Range = range;
            this.Schema = schema;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Uri
        /// </summary>
        [DataMember(Name = "uri", IsRequired = true, EmitDefaultValue = true)]
        public string Uri { get; set; }

        /// <summary>
        /// Gets or Sets Range
        /// </summary>
        [DataMember(Name = "range", IsRequired = true, EmitDefaultValue = true)]
        public LanguageServerProtocolLocationRange Range { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class LanguageServerProtocolLocation {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Uri: ").Append(Uri).Append("\n");
            sb.Append("  Range: ").Append(Range).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
