/*
 * Pieces Isomorphic OpenAPI
 *
 * Endpoints for Assets, Formats, Users, Asset, Format, User.
 *
 * The version of the OpenAPI document: 1.0
 * Contact: tsavo@pieces.app
 * Generated by: https://github.com/openapitools/openapi-generator.git
 */


using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Text;
using System.Text.RegularExpressions;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System.ComponentModel.DataAnnotations;
using OpenAPIDateConverter = Pieces.Os.Core.Client.OpenAPIDateConverter;

namespace Pieces.Os.Core.SdkModel
{
    /// <summary>
    /// TODO
    /// </summary>
    [DataContract(Name = "LanguageServerProtocolDiagnostic")]
    public partial class LanguageServerProtocolDiagnostic : IValidatableObject
    {

        /// <summary>
        /// Gets or Sets Severity
        /// </summary>
        [DataMember(Name = "severity", EmitDefaultValue = false)]
        public LanguageServerProtocolSeverityEnum? Severity { get; set; }
        /// <summary>
        /// Initializes a new instance of the <see cref="LanguageServerProtocolDiagnostic" /> class.
        /// </summary>
        [JsonConstructorAttribute]
        protected LanguageServerProtocolDiagnostic() { }
        /// <summary>
        /// Initializes a new instance of the <see cref="LanguageServerProtocolDiagnostic" /> class.
        /// </summary>
        /// <param name="schema">schema.</param>
        /// <param name="range">range (required).</param>
        /// <param name="severity">severity.</param>
        /// <param name="code">code.</param>
        /// <param name="codeDescription">codeDescription.</param>
        /// <param name="source">source.</param>
        /// <param name="message">message (required).</param>
        public LanguageServerProtocolDiagnostic(EmbeddedModelSchema schema = default(EmbeddedModelSchema), LanguageServerProtocolLocationRange range = default(LanguageServerProtocolLocationRange), LanguageServerProtocolSeverityEnum? severity = default(LanguageServerProtocolSeverityEnum?), LanguageServerProtocolCode code = default(LanguageServerProtocolCode), LanguageServerProtocolCodeDescription codeDescription = default(LanguageServerProtocolCodeDescription), string source = default(string), string message = default(string))
        {
            // to ensure "range" is required (not null)
            if (range == null)
            {
                throw new ArgumentNullException("range is a required property for LanguageServerProtocolDiagnostic and cannot be null");
            }
            this.Range = range;
            // to ensure "message" is required (not null)
            if (message == null)
            {
                throw new ArgumentNullException("message is a required property for LanguageServerProtocolDiagnostic and cannot be null");
            }
            this.Message = message;
            this.Schema = schema;
            this.Severity = severity;
            this.Code = code;
            this.CodeDescription = codeDescription;
            this.Source = source;
        }

        /// <summary>
        /// Gets or Sets Schema
        /// </summary>
        [DataMember(Name = "schema", EmitDefaultValue = false)]
        public EmbeddedModelSchema Schema { get; set; }

        /// <summary>
        /// Gets or Sets Range
        /// </summary>
        [DataMember(Name = "range", IsRequired = true, EmitDefaultValue = true)]
        public LanguageServerProtocolLocationRange Range { get; set; }

        /// <summary>
        /// Gets or Sets Code
        /// </summary>
        [DataMember(Name = "code", EmitDefaultValue = false)]
        public LanguageServerProtocolCode Code { get; set; }

        /// <summary>
        /// Gets or Sets CodeDescription
        /// </summary>
        [DataMember(Name = "codeDescription", EmitDefaultValue = false)]
        public LanguageServerProtocolCodeDescription CodeDescription { get; set; }

        /// <summary>
        /// Gets or Sets Source
        /// </summary>
        [DataMember(Name = "source", EmitDefaultValue = false)]
        public string Source { get; set; }

        /// <summary>
        /// Gets or Sets Message
        /// </summary>
        [DataMember(Name = "message", IsRequired = true, EmitDefaultValue = true)]
        public string Message { get; set; }

        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("class LanguageServerProtocolDiagnostic {\n");
            sb.Append("  Schema: ").Append(Schema).Append("\n");
            sb.Append("  Range: ").Append(Range).Append("\n");
            sb.Append("  Severity: ").Append(Severity).Append("\n");
            sb.Append("  Code: ").Append(Code).Append("\n");
            sb.Append("  CodeDescription: ").Append(CodeDescription).Append("\n");
            sb.Append("  Source: ").Append(Source).Append("\n");
            sb.Append("  Message: ").Append(Message).Append("\n");
            sb.Append("}\n");
            return sb.ToString();
        }

        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public virtual string ToJson()
        {
            return Newtonsoft.Json.JsonConvert.SerializeObject(this, Newtonsoft.Json.Formatting.Indented);
        }

            /// <summary>
            /// To validate all properties of the instance
            /// </summary>
            /// <param name="validationContext">Validation context</param>
            /// <returns>Validation Result</returns>
            IEnumerable<System.ComponentModel.DataAnnotations.ValidationResult> IValidatableObject.Validate(ValidationContext validationContext)
            {
            yield break;
        }
    }

}
